package group_ev

import (
	"git.hilo.cn/hilo-common/domain"
)

/**
*
 */
type GroupKickOutEvent struct {
	GroupId            string
	OperatorExternalId string `json:"operatorExternalId"`
	OperatorName       string `json:"operatorName"`
	OperatorFaceUrl    string `json:"operatorFaceUrl"`
	MemberExternalId   string `json:"memberExternalId"`
	MemberName         string `json:"memberName"`
	MemberAvatar       string `json:"memberAvatar"`
}

//注册监听
var groupKickOutListen = new(domain.EventBase)

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddGroupKickOutSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(groupKickOutListen, callback)
}

//加入到异步操作中
func AddGroupKickOutAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(groupKickOutListen, callback)
}

//领域事件发布
func PublishGroupKickOut(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(groupKickOutListen, model, event)
}
