package group_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

type GroupInEvent struct {
	GroupId    string
	UserId     mysql.ID
	ExternalId string
	Nick       string
	Avatar     string
	IsMember   bool //是否永久成员
	IsVip      bool
	NobleLevel uint16
}

//注册监听
var groupInListen = new(domain.EventBase)

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddGroupInSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(groupInListen, callback)
}

//加入到异步操作中
func AddGroupInAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(groupInListen, callback)
}

//领域事件发布
func PublishGroupIn(model *domain.Model, event *GroupInEvent) error {
	return domain.PublishEvent(groupInListen, model, event)
}
