package mic_k

import (
	"fmt"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/_const/redis_key"
	"time"
)

const (
	MicPrefix    = "mic:"
	MicDayInvite = MicPrefix + "day:invite:${userId}:${date}" // string 自动被邀请上麦,1天一次,TTL:24H

	MicGroupPowerOnMic = MicPrefix + "groupPower:${userId}:${date}" // 家族内群上麦分钟数
	MicUserOnMic       = MicPrefix + "user:onMic:${tz}:${userId}:${date}"

	MicGroupOnMic = MicPrefix + "group:onMic:${groupId}" // 在群组麦位上的人 hset field:micIndex member:userId
)

func GetUserMicDayInvite(userId mysql.ID) string {
	date := time.Now().Format("2006-01-02")
	return redis_key.ReplaceKey(MicDayInvite, fmt.Sprintf("%d", userId), date)
}

// 家族内群上麦分钟数
func GetMicGroupPowerOnMic(userId uint64) string {
	date := time.Now().Format("2006-01-02")
	return redis_key.ReplaceKey(MicGroupPowerOnMic, fmt.Sprintf("%d", userId), date)
}

// 获取用户上麦时间
// 北京、沙特时间
func GetUserOnMicKey(userId uint64, tz, date string) string {
	return redis_key.ReplaceKey(MicUserOnMic, tz, fmt.Sprintf("%d", userId), date)
}

// 获取群组麦位上的人
// 可能会有数据不一致,已原来麦位的key为准
// 这里用户快速获取群上麦位的人用，代替大量mget命令慢查询
func GetGroupOnMicUser(groupId string) string {
	return redis_key.ReplaceKey(MicGroupOnMic, groupId)
}
