package redis_key

import (
	"strconv"
	"strings"
	"time"
)

//online
const online = "online"

//online
const onlineVersion = "online_{version}"

//online lock
const onlineLock = "online_lock_{version}"

//redis的广播，接收到的数据，匹配结果锁
const matchCycleSuccessSubscribeLock = "match_cycle_success_subscribe_lock_{matchUid}"

//redis的广播，接收到的数据，匹配周期结果锁
const matchCycleSubscribeLock = "match_cycle_subscribe_lock_{version}"

//redis的广播，match数据的进行
const matchCron = "match_cron_{dateStr}"

//匹配的工会用户
const matchTradeUnion = "match_trade_union_{version}"

//匹配，用户信息
const matchUser = "match_user_{version}"

//匹配，用户优先度排序
const matchPriority = "match_priority_{version}"

//匹配，质量分数
const matchExcellent = "match_excellent_{version}"

//匹配，关系分数
const matchRelation = "match_relation_{version}_{userId}"

//匹配优先度构成
const matchPriorityForm = "match_priority_form_{version}"

//匹配，质量分数构成
const matchExcellentForm = "match_excellent_form_{version}"

//匹配，关系分数构成
const matchRelationForm = "match_relation_form_{version}"

//匹配，拉黑名单
const matchBlock = "match_block_{version}"

//匹配，条件性别
const matchConditionSex = "match_condition_sex_{version}"

//匹配，条件国家
const matchConditionCountry = "match_condition_country_{version}"

//匹配确认
const matchConfirm = "match_confirm_{channelId}"

//匹配免费确认
const matchAddFreeTime = "match_add_free_time_{matchUid}"

//匹配第一帧
const matchCallReady = "match_call_ready_{matchUid}"

//已匹配的周期
const matchCycle = "match_cycle_{cycle}"

//用户召回弹窗
const recallWindow = "match_recall_window_{userId}"

//用户匹配拒绝的时间, 24小时过期
const userBeMatchRefuse = "user_be_match_refuse_{userId}"

//用户匹配确认的时间
const userValidMatchConfirm = "user_valid_match_confirm_{userId}"

//用户活跃时间
const userActiveTime = "user_active_time"

//推荐用户活跃时间
const recommendActiveTime = "recommend_active_time"

//每一分钟的产生的推荐列表，存在有效期，有效期是一天
const recommentListUnix = "recomment_list_{unix}"

//每一分钟的产生的推荐列表，加锁，避免多次产生
const recommentListUnixLock = "recomment_list_{unix}_lock"

//推荐用户, 记录起来，用户算法中心获取。
const recommendUser = "recommend_user"

//

//1对1视频第一帧
const videoCallReady = "video_call_ready_{videoUid}"

//1对1视频第免费确认
const videoAddFreeTime = "video_add_free_time_{videoUid}"

// 用户日活
const countDailyUserLoginPreix = "daily_user_login_{date}"

// IM在线状态
const onlineStatusPreix = "online_status_{extId}"

// user状态
const userStatusPrefix = "user_status_{userId}"

// mgr_imei统计数
const mgrImeiCountPrefix = "mgr_imei_count_{imei}"

// mgr_ip统计数
const mgrIpCountPrefix = "mgr_ip_count_{ip}"

// 群成员人数
const groupMemberCountPrefix = "group_mem_count_{groupId}"

// 群的成员
const GroupMemberPrefix = "group_member_{groupId}"

// 群消费额
const GroupConsumePrefix = "group_consume_{groupId}"

//榜单活动开始锁
const activityBillboardMatchBeLikeStartLock = "activity_billboard_matchBeLike_start_lock_{date}"

//榜单活动结束锁
const activityBillboardMatchBeLikeEndLock = "activity_billboard_matchBeLike_end_lock_{date}"

//榜单活动奖励锁
const activityBillboardMatchBeLikeRewardLock = "activity_billboard_matchBeLike_reward_lock_{date}"

//榜单活动开始锁
const activityBillboardCpStartLock = "activity_billboard_cp_start_lock_{date}"

//榜单活动结束锁
const activityBillboardCpEndLock = "activity_billboard_cp_end_lock_{date}"

//榜单活动奖励锁
const activityBillboardCpRewardLock = "activity_billboard_cp_reward_lock_{date}"

//榜单活动开始锁
const activityGroupBillboardStartLock = "activity_group_billboard_start_lock_{date}"

//榜单活动开始锁
const activityGroupBillboardEndLock = "activity_group_billboard_end_lock_{date}"

//榜单活动发布奖励锁
const activityGroupBillboardRewardLock = "activity_group_billboard_reward_lock_{date}"

//榜单活动开始锁
const activityBillboardMonthlyWealthStartLock = "activity_billboard_monthly_wealth_start_lock_{date}"

//榜单活动结束锁
const activityBillboardMonthlyWealthEndLock = "activity_billboard_monthly_wealth_end_lock_{date}"

//榜单活动奖励锁
const activityBillboardMonthlyWealthRewardLock = "activity_billboard_monthly_wealth_reward_lock_{date}"

//榜单活动开始锁
const activityBillboardMonthlyCharmStartLock = "activity_billboard_monthly_charm_start_lock_{date}"

//榜单活动结束锁
const activityBillboardMonthlyCharmEndLock = "activity_billboard_monthly_charm_end_lock_{date}"

//榜单活动奖励锁
const activityBillboardMonthlyCharmRewardLock = "activity_billboard_monthly_charm_reward_lock_{date}"

//榜单活动开始锁
const activityBillboardMonthlyPayStartLock = "activity_billboard_monthly_pay_start_lock_{date}"

//榜单活动结束锁
const activityBillboardMonthlyPayEndLock = "activity_billboard_monthly_pay_end_lock_{date}"

//榜单活动奖励锁
const activityBillboardMonthlyPayRewardLock = "activity_billboard_monthly_pay_reward_lock_{date}"

//榜单活动开始锁
const activityBillboardMonthlyGroupStartLock = "activity_billboard_monthly_group_start_lock_{date}"

//榜单活动结束锁
const activityBillboardMonthlyGroupEndLock = "activity_billboard_monthly_group_end_lock_{date}"

//榜单活动奖励锁
const activityBillboardMonthlyGroupRewardLock = "activity_billboard_monthly_group_reward_lock_{date}"

//榜单活动结束锁
const activityBillboardTunisiaMationalDayUserEndLock = "activity_billboard_tunisia_mational_day_user_end_lock_{date}"

//榜单活动奖励锁
const activityBillboardTunisiaMationalDayUserRewardLock = "activity_billboard_tunisia_mational_day_user_reward_lock_{date}"

//榜单活动结束锁
const activityBillboardTunisiaMationalDayGroupEndLock = "activity_billboard_tunisia_mational_day_group_end_lock_{date}"

//榜单活动奖励锁
const activityBillboardTunisiaMationalDayGroupRewardLock = "activity_billboard_tunisia_mational_day_group_reward_lock_{date}"

//榜单活动开始锁
const activityBillboardDayPayDealerStartLock = "activity_billboard_day_pay_dealer_start_lock_{date}"

//榜单活动结束锁
const activityBillboardDayPayDealerEndLock = "activity_billboard_day_pay_dealer_end_lock_{date}"

//榜单活动开始锁
const activityBillboardMonthPayDealerStartLock = "activity_billboard_month_pay_dealer_start_lock_{date}"

//榜单活动结束锁
const activityBillboardMonthPayDealerEndLock = "activity_billboard_month_pay_dealer_end_lock_{date}"

//周星PK活动
const activityBillboardGroupStartPk = "activity_billboard_group_start_pk_lock_{date}"

//活动周期
const activityCronNewLock = "activity_cron_new_lock_{type}_{timestamp}"
const activityCronEndLock = "activity_cron_end_lock_{type}_{timestamp}"
const activityCronRewardLock = "activity_cron_reward_lock_{type}_{timestamp}"

// 礼物周星活动互斥锁
const weeklyStarStartLock = "weekly_star_start_lock_{date}"
const weeklyStarEndLock = "weekly_star_end_lock_{date}"
const weeklyStarRewardLock = "weekly_star_reward_lock_{date}"

// 国家之星cron互斥锁
const countryStarCronLock = "country_star_cron_{task}_{date}"

//群的最大消息序列号
const groupMsgSeqMaxAll = "group_msg_seq_max_all"

//群中用户的最大消息序列号
const groupMsgSeqMaxGroup = "group_msg_seq_max_{uuid}"

//5分钟内群中消息用户数量(所有群)
const groupMsgDurationUser = "group_msg_duration_user"

//5分钟内群中消息用户数的群排名
const groupMsgDurationScore = "group_msg_duration_score"

//快照
const groupMsgDurationScoreSnap = "group_msg_duration_score_snap"

// 15天内进入房间的人（重复进入去重）
const groupInUserDuration = "group_in_user_duration_{groupUuid}"

// 15天内进入房间的人数
const roomVisitCount = "room_visit_count"

// 15天内进入房间的人数 member groupId score 麦位有人的数量
const roomVisitCountZSet = "room_visit_count_zset"

// 用户进入过的房间及时间
const userEnterRoom = "enter_room_{userId}"

// 群支持度
const supportLevel = "supportLevel_{date}"

// 国家势力周期内收获的钻石
const groupPowerDiamond = "group_diamond_{period}"

// 国家Icon
const countryIcon = "contry_icon"

// 国家Area
const countryArea = "contry:area"

// 群贡献前三
const groupTop3Consume = "group_top3_consume_{period}_{groupId}"

// 国家贡献前三
const countryTop3Consume = "country_top3_consume_{country}"

//群组麦位内容
const groupMicGroup = "group_mic_{groupUuid}"

//核心
//群组麦上的人
const groupMicUser = "group_mic_user_{groupUuid}_{i}"

//核心
//麦上的人，用于控制一个只能上一个麦，利用lua表达式，让groupUserMic 同 groupMicUser保持一致性。
const groupUserInMic = "group_user_in_mic_{externalId}"

//群组麦上del锁
const groupMicUserDelLock = "group_mic_user_del_lock_{groupUuid}_{i}"

//群组麦上上麦锁
const groupMicUserInLock = "group_mic_user_in_lock_{userId}"

//群组踢人,设计有效期，有效期一过，踢人时效性就没有了。
const groupKickGroupUuidUserId = "group_kick_{groupUuid}_{userId}"

//群发言, 记录在哪个群发过言，
const groupMsgDateUser = "group_msg_{date}_{userExternalId}"

//群麦上数量类型设置
const groupMicNumType = "group_mic_num_type_{groupUuid}"

//麦上有人的群
const groupMicHasIn = "group_mic_has_in"

//麦上有人的群+用户+时间
const groupMicHasInUserTime = "group_mic_has_in_user_time"

//在房间的人
const groupRoomLiving = "group_room_living"

//定时任务锁,系统消息锁
const msgSysCronLock = "msg_sys_cron_lock"

//一周下群组消息的人, set结构
const groupMsgWeekUser = "group_msg_week_user_{groupId}"

//一周下群组消息的人数（是人数）, sort set结构
const groupMsgWeekUserN = "group_msg_week_user_n"

//每天领取的钻石
const dailyInAppDiamond = "daily_in_app_diamond"

//定时任务，vip订阅检查
const vipSubscribeLock = "vip_subscribe_lock"
const giftReturnLock = "gift_return_lock"

// 定时任务的互斥锁
const cronLock = "cronLock:{subKey}"

const authorizeWindow = "authorize_window_{userId}"
const syncTimHiloLock = "sync_tim_hilo_{userId}"

// 火箭观众
const rocketGuest = "rocket_guest_{id}_{userId}"

// 用户访问运营弹窗
const operationWindow = "operation_window_{date}_{userId}"

//上麦10分钟.设计：双重保证，存在过期时间，判断key中带有时间
const taskMic10Min = "task_mic_10_min_{userId}_{dateStr}"

//活跃值，（每3分钟，就有1分），设计：3分钟过期，存在，则说明还不到三分钟。
const actityDailyInMic = "actity_daily_in_mic_{userId}"

//幸运盒子购买钻石-奖励钻石的结果差值。存在有效期
const luckyboxBuyAward = "luckybox_buy_award_{userId}"

// 用户请求频率
const userQps = "user_qps_{userId}_{sec}"

// 用户URL请求频率
const userUrlQps = "user_qps_{userId}_{url}_{sec}"

//国家势力流水，按周
const groupPowerDiamondLogWeek = "group_power_diamond_log_week_{dateStr}"

//sortset 结构 key:date key:groupUid score:得分
const giftOperateDay = "gift_operate_groupUid_day_{dateStr}"
const giftOperateWeek = "gift_operate_groupUid_week_{weekStr}"
const giftOperateMonth = "gift_operate_groupUid_month_{monthStr}"

//sortset 结构 key:date key:senderUserId score:得分
const giftOperateSendUserIdDay = "gift_operate_send_userId_day_{dateStr}"
const giftOperateSendUserIdWeek = "gift_operate_send_userId_week_{weekStr}"
const giftOperateSendUserIdMonth = "gift_operate_send_userId_month_{monthStr}"

//sortset 结构 key:date key:receiveUserId score:得分
const giftOperateReceiveUserIdDay = "gift_operate_receive_userId_day_{dateStr}"
const giftOperateReceiveUserIdWeek = "gift_operate_receive_userId_week_{weekStr}"
const giftOperateReceiveUserIdMonth = "gift_operate_receive_userId_month_{monthStr}"

const giftOperate1HourDurationGroupId = "gift_operate_1hour_duration_groupId_{groupUid}"

//sortset 结构 key:groupUid_date key:userId score:得分
const giftOperateGroupUidDay = "gift_operate_groupUid_day_{dateStr}_{groupUid}"
const giftOperateGroupUidWeek = "gift_operate_groupUid_week_{dateStr}_{groupUid}"
const giftOperateGroupUidMonth = "gift_operate_groupUid_month_{monthStr}_{groupUid}"

const giftOperateReceiveGroupUidDay = "gift_operate_receive_groupUid_day_{dateStr}_{groupUid}"
const giftOperateReceiveGroupUidWeek = "gift_operate_receive_groupUid_week_{dateStr}_{groupUid}"
const giftOperateReceiveGroupUidMonth = "gift_operate_receive_groupUid_month_{monthStr}_{groupUid}"

//幸运盒子的活动，记录用户的中奖总额
const luckyboxUserSumSunday = "luckyboxUserSum_{sunday}"

//幸运盒子的活动，记录奖金池的数量
const luckyboxPoolSumSunday = "luckyboxPoolSum_{sunday}"

const groupOnlineUser = "group_online_user_{groupUid}"

const micInfoChange = "mic_info_change"

const micInUserTemp = "mic_in_user_temp_{userExternalIds}"

//视频分钟，定时状态check，检查
const videoMinuteCronCheck = "video_minute_cron_check_{uuid}"
const videoMinuteCronDeal = "video_minute_cron_deal_{uuid}"
const videoMinuteCronEnd = "video_minute_cron_end_{videoUid}"

//下一个扣钱的队列, 使用sort set结构，
//const videoNextMinute = "video_next_minute"

// --------------------------缓存时间相关常量-------------------------------------------
const GroupInDurationTTL = 15
const GroupInDurationClearPeriod = 15

func GetPrefixOnline() string {
	return online
}

func GetPrefixOnlineVersion(version string) string {
	return strings.Replace(onlineVersion, "{version}", version, -1)
}

func GetPrefixOnlineLock(version string) string {
	return strings.Replace(onlineLock, "{version}", version, -1)
}

func GetPrefixMatchUser(version string) string {
	return strings.Replace(matchUser, "{version}", version, -1)
}

func GetPrefixMatchPriority(version string) string {
	return strings.Replace(matchPriority, "{version}", version, -1)
}

func GetPrefixMatchExcellent(version string) string {
	return strings.Replace(matchExcellent, "{version}", version, -1)
}

func GetPrefixMatchRelation(version string, userId string) string {
	return strings.Replace(strings.Replace(matchRelation, "{version}", version, -1), "{userId}", userId, -1)
}

func GetPrefixMatchPriorityForm(version string) string {
	return strings.Replace(matchPriorityForm, "{version}", version, -1)
}

func GetPrefixMatchExcellentForm(version string) string {
	return strings.Replace(matchExcellentForm, "{version}", version, -1)
}

func GetPrefixMatchRelationForm(version string) string {
	return strings.Replace(matchRelationForm, "{version}", version, -1)
}

func GetPrefixMatchBlock(version string) string {
	return strings.Replace(matchBlock, "{version}", version, -1)
}

func GetPrefixMatchConditionSex(version string) string {
	return strings.Replace(matchConditionSex, "{version}", version, -1)
}

func GetPrefixMatchConditionCountry(version string) string {
	return strings.Replace(matchConditionCountry, "{version}", version, -1)
}

func GetPrefixMatchConfirm(channelId string) string {
	return strings.Replace(matchConfirm, "{channelId}", channelId, -1)
}

func GetPrefixMatchAddFreeTime(matchUid string) string {
	return strings.Replace(matchAddFreeTime, "{matchUid}", matchUid, -1)
}

func GetPrefixMatchCallReady(matchUid string) string {
	return strings.Replace(matchCallReady, "{matchUid}", matchUid, -1)
}

func GetPrefixMatchCycle(cycle int64) string {
	return strings.Replace(matchCallReady, "{matchUid}", strconv.Itoa(int(cycle)), -1)
}

func GetPreMatchTradeUnion(version string) string {
	return strings.Replace(matchTradeUnion, "{version}", version, -1)
}

func GetPreMatchCycleSuccessSubscribeLock(matchUid string) string {
	return strings.Replace(matchCycleSuccessSubscribeLock, "{matchUid}", matchUid, -1)
}

func GetPreMatchCycleSubscribeLock(version string) string {
	return strings.Replace(matchCycleSubscribeLock, "{version}", version, -1)
}

func GetPreMatchCron(dateStr string) string {
	return strings.Replace(matchCron, "{dateStr}", dateStr, -1)
}

func GetPreRecallWindow(userId uint64) string {
	return strings.Replace(recallWindow, "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetPreUserBeMatchRefuse(userId uint64) string {
	return strings.Replace(userBeMatchRefuse, "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetPreUserValidMatchConfirm(userId uint64) string {
	return strings.Replace(userValidMatchConfirm, "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetPreUserActiveTime() string {
	return userActiveTime
}

func GetPreRecommendActiveTime() string {
	return recommendActiveTime
}

func GetPreRecommendUser() string {
	return recommendUser
}

func GetPreRecommentListUnix(unix string) string {
	return strings.Replace(recommentListUnix, "{unix}", unix, -1)
}

func GetPreRecommentListUnixLock(unix string) string {
	return strings.Replace(recommentListUnixLock, "{unix}", unix, -1)
}

func GetPrefixVideoCallReady(videoUid string) string {
	return strings.Replace(videoCallReady, "{videoUid}", videoUid, -1)
}

func GetPrefixVideoAddFreeTime(videoUid string) string {
	return strings.Replace(videoAddFreeTime, "{videoUid}", videoUid, -1)
}

func GetPrefixActivityBillboardMatchBeLikeStartLock(date string) string {
	return strings.Replace(activityBillboardMatchBeLikeStartLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMatchBeLikeEndLock(date string) string {
	return strings.Replace(activityBillboardMatchBeLikeEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMatchBeLikeRewardLock(date string) string {
	return strings.Replace(activityBillboardMatchBeLikeRewardLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardCpStartLock(date string) string {
	return strings.Replace(activityBillboardCpStartLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardCpEndLock(date string) string {
	return strings.Replace(activityBillboardCpEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardCpRewardLock(date string) string {
	return strings.Replace(activityBillboardCpRewardLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyWealthStartLock(date string) string {
	return strings.Replace(activityBillboardMonthlyWealthStartLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyWealthEndLock(date string) string {
	return strings.Replace(activityBillboardMonthlyWealthEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyWealthRewardLock(date string) string {
	return strings.Replace(activityBillboardMonthlyWealthRewardLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyCharmStartLock(date string) string {
	return strings.Replace(activityBillboardMonthlyCharmStartLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyCharmEndLock(date string) string {
	return strings.Replace(activityBillboardMonthlyCharmEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyCharmRewardLock(date string) string {
	return strings.Replace(activityBillboardMonthlyCharmRewardLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyPayStartLock(date string) string {
	return strings.Replace(activityBillboardMonthlyPayStartLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyPayEndLock(date string) string {
	return strings.Replace(activityBillboardMonthlyPayEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyPayRewardLock(date string) string {
	return strings.Replace(activityBillboardMonthlyPayRewardLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyGroupStartLock(date string) string {
	return strings.Replace(activityBillboardMonthlyGroupStartLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyGroupEndLock(date string) string {
	return strings.Replace(activityBillboardMonthlyGroupEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthlyGroupRewardLock(date string) string {
	return strings.Replace(activityBillboardMonthlyGroupRewardLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardTunisiaMationalDayUserEndLock(date string) string {
	return strings.Replace(activityBillboardTunisiaMationalDayUserEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardTunisiaMationalDayUserRewardLock(date string) string {
	return strings.Replace(activityBillboardTunisiaMationalDayUserRewardLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardTunisiaMationalDayGroupEndLock(date string) string {
	return strings.Replace(activityBillboardTunisiaMationalDayGroupEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardTunisiaMationalDayGroupRewardLock(date string) string {
	return strings.Replace(activityBillboardTunisiaMationalDayGroupRewardLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardDayPayDealerStartLock(date string) string {
	return strings.Replace(activityBillboardDayPayDealerStartLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardDayPayDealerEndLock(date string) string {
	return strings.Replace(activityBillboardDayPayDealerEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthPayDealerStartLock(date string) string {
	return strings.Replace(activityBillboardMonthPayDealerStartLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardMonthPayDealerEndLock(date string) string {
	return strings.Replace(activityBillboardMonthPayDealerEndLock, "{date}", date, -1)
}

func GetPrefixActivityBillboardGroupStartPkLock(date string) string {
	return strings.Replace(activityBillboardGroupStartPk, "{date}", date, -1)
}

//活动周期
//const activityCronEndLock = "activity_cron_end_lock_{type}_{timestamp}"
//const activityCronRewardLock = "activity_cron_reward_lock_{type}_{timestamp}"

func GetPrefixActivityCronNewLock(t uint8, ti time.Time) string {
	return strings.Replace(strings.Replace(activityCronNewLock, "{type}", strconv.FormatUint(uint64(t), 10), -1), "{timestamp}", strconv.FormatInt(ti.Unix(), 10), -1)
}

func GetPrefixActivityCronEndLock(t uint8, ti time.Time) string {
	return strings.Replace(strings.Replace(activityCronEndLock, "{type}", strconv.FormatUint(uint64(t), 10), -1), "{timestamp}", strconv.FormatInt(ti.Unix(), 10), -1)
}

func GetPrefixActivityCronRewardLock(t uint8, ti time.Time) string {
	return strings.Replace(strings.Replace(activityCronRewardLock, "{type}", strconv.FormatUint(uint64(t), 10), -1), "{timestamp}", strconv.FormatInt(ti.Unix(), 10), -1)
}

func GetWeeklyStarStartLockKey(date string) string {
	return strings.Replace(weeklyStarStartLock, "{date}", date, -1)
}

func GetWeeklyStarEndLockKey(date string) string {
	return strings.Replace(weeklyStarEndLock, "{date}", date, -1)
}

func GetWeeklyStarRewardLockKey(date string) string {
	return strings.Replace(weeklyStarRewardLock, "{date}", date, -1)
}

func GetCountryStarCronLock(task, date string) string {
	return strings.Replace(strings.Replace(countryStarCronLock, "{task}", task, -1), "{date}", date, -1)
}

func GetPrefixActivityGroupBillboardStartLock(date string) string {
	return strings.Replace(activityGroupBillboardStartLock, "{date}", date, -1)
}

func GetPrefixActivityGroupBillboardEndLock(date string) string {
	return strings.Replace(activityGroupBillboardEndLock, "{date}", date, -1)
}

func GetPrefixActivityGroupBillboardRewardLock(date string) string {
	return strings.Replace(activityGroupBillboardRewardLock, "{date}", date, -1)
}

func GetPrefixGroupMsgSeqMaxAll() string {
	return groupMsgSeqMaxAll
}

func GetPrefixGroupMsgSeqMaxGroup(groupUuid string) string {
	return strings.Replace(groupMsgSeqMaxGroup, "{uuid}", groupUuid, -1)
}

func GetPrefixGroupMsgDurationUser() string {
	return groupMsgDurationUser
}

func GetPrefixGroupMsgDurationScore() string {
	return groupMsgDurationScore
}

func GetPrefixGroupMsgDurationScoreSnap() string {
	return groupMsgDurationScoreSnap
}

func GetPrefixGroupMic(groupUuid string) string {
	return strings.Replace(groupMicGroup, "{groupUuid}", groupUuid, -1)
}

func GetPrefixGroupMicUser(groupUuid string, i int) string {
	return strings.Replace(strings.Replace(groupMicUser, "{groupUuid}", groupUuid, -1), "{i}", strconv.Itoa(i), -1)
}

func GetPrefixGroupMicUserDelLock(groupUuid string, i int) string {
	return strings.Replace(strings.Replace(groupMicUserDelLock, "{groupUuid}", groupUuid, -1), "{i}", strconv.Itoa(i), -1)
}

func GetPrefixGroupMicUserInLock(userId uint64) string {
	return strings.Replace(groupMicUserInLock, "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetPrefixGroupUserInMic(externalId string) string {
	return strings.Replace(groupUserInMic, "{externalId}", externalId, -1)
}

func GetGroupKickGroupUuidUserId(groupUuid string, userId uint64) string {
	return strings.Replace(strings.Replace(groupKickGroupUuidUserId, "{groupUuid}", groupUuid, -1), "{userId}", strconv.Itoa(int(userId)), -1)
}

func GetGroupMsgDateUser(userExternalId string, date time.Time) string {
	return strings.Replace(strings.Replace(groupMsgDateUser, "{date}", date.Format("2006-01-02"), -1), "{userExternalId}", userExternalId, -1)
}

func GetPrefixGroupMsgWeekUser(groupId string) string {
	return strings.Replace(groupMsgWeekUser, "{groupId}", groupId, -1)
}

func GetPrefixGroupMsgWeekUserM() string {
	return groupMsgWeekUserN
}

func GetMsgSysCronLock() string {
	return msgSysCronLock
}

func GetPrefixDailyInAppDiamond() string {
	return dailyInAppDiamond
}

func GetPrefixVipSubscribeLock() string {
	return vipSubscribeLock
}

func GetGiftReturnLockKey() string {
	return giftReturnLock
}

func GetCronLockKey(subKey string) string {
	return strings.Replace(cronLock, "{subKey}", subKey, -1)
}

func GetPrefixGroupMicNumType(groupUuid string) string {
	return strings.Replace(groupMicNumType, "{groupUuid}", groupUuid, -1)
}

// Deprecated: 用户进房时间
// 用 uer:g:${group_id}代替
func GetPrefixGroupInUserDuration(groupUuid string) string {
	return strings.Replace(groupInUserDuration, "{groupUuid}", groupUuid, -1)
}

// Deprecated: 用户进房时间
// 可用 uer:u:${user_id}代替
func GetUserEnterRoomKey(userId uint64) string {
	return strings.Replace(userEnterRoom, "{userId}", strconv.FormatUint(userId, 10), -1)
}

// Deprecated: 用redis集群中的zset代替
func GetPrefixRoomVisitCount() string {
	return roomVisitCount
}

func GetPrefixRoomVisitCountZset() string {
	return roomVisitCountZSet
}

func GetPrefixSupportLevel(date string) string {
	return strings.Replace(supportLevel, "{date}", date, -1)
}

func GetPrefixGroupPowerDiamond(period string) string {
	return strings.Replace(groupPowerDiamond, "{period}", period, -1)
}

func GetCountryIconKey() string {
	return countryIcon
}

func GetCountryAreaKey() string {
	return countryArea
}

func GetGroupTop3ConsumeKey(period string, groupId string) string {
	return strings.Replace(strings.Replace(groupTop3Consume, "{period}", period, -1), "groupId", groupId, -1)
}

func GetCountryTop3ConsumeKey(country string) string {
	return strings.Replace(countryTop3Consume, "{country}", country, -1)
}

func GetPrefixGroupMicHasIn() string {
	return groupMicHasIn
}

func GetPrefixGroupMicHasInUserTime() string {
	return groupMicHasInUserTime
}

func GetPrefixAuthorizeWindow(userId uint64) string {
	return strings.Replace(authorizeWindow, "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetKeySyncTimHilo(userId uint64) string {
	return strings.Replace(syncTimHiloLock, "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetPrefixGroupRoomLiving() string {
	return groupRoomLiving
}

func GetOperationWindowKey(date string, userId uint64) string {
	return strings.Replace(strings.Replace(operationWindow, "{date}", date, -1), "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetPrefixTaskMic10Min(userId uint64, dateStr string) string {
	return strings.Replace(strings.Replace(taskMic10Min, "{dateStr}", dateStr, -1), "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetPrefixActityDailyInMic(userId uint64) string {
	return strings.Replace(actityDailyInMic, "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetCountUserLoginKey(date string) string {
	return strings.Replace(countDailyUserLoginPreix, "{date}", date, -1)
}

func GetGroupMemCountKey(groupId string) string {
	return strings.Replace(groupMemberCountPrefix, "{groupId}", groupId, -1)
}

func GetOnLineStatusKey(extId string) string {
	return strings.Replace(onlineStatusPreix, "{extId}", extId, -1)
}

func GetUserStatusKey(userId uint64) string {
	return strings.Replace(userStatusPrefix, "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetMgrImeiCountKey(imei string) string {
	return strings.Replace(mgrImeiCountPrefix, "{imei}", imei, -1)
}

func GetMgrIpCountKey(ip string) string {
	return strings.Replace(mgrIpCountPrefix, "{ip}", ip, -1)
}

func GetRocketGuestKey(resultId uint64, userId uint64) string {
	u := strconv.FormatUint(userId, 10)
	id := strconv.FormatUint(resultId, 10)
	return strings.Replace(strings.Replace(rocketGuest, "{userId}", u, -1), "{id}", id, -1)
}

func GetLuckyboxBuyAward(userId uint64) string {
	return strings.Replace(luckyboxBuyAward, "{userId}", strconv.FormatUint(userId, 10), -1)
}

func GetUserQps(userId uint64, sec uint64) string {
	return strings.Replace(strings.Replace(userQps, "{userId}", strconv.FormatUint(userId, 10), -1), "{sec}", strconv.FormatUint(sec, 10), -1)
}

func GetUserUrlQps(userId uint64, url string, sec uint64) string {
	return strings.Replace(
		strings.Replace(
			strings.Replace(userUrlQps, "{userId}", strconv.FormatUint(userId, 10), -1),
			"{url}", url, -1),
		"{sec}", strconv.FormatUint(sec, 10), -1)
}

func GetGroupPowerDiamondLogWeek(dateStr string) string {
	return strings.Replace(groupPowerDiamondLogWeek, "{dateStr}", dateStr, -1)
}

func GetGroupOnlineUser(groupUid string) string {
	return strings.Replace(groupOnlineUser, "{groupUid}", groupUid, -1)
}

func GetGiftOperateGroupUidDay(groupUid string, dateStr string) string {
	return strings.Replace(strings.Replace(giftOperateGroupUidDay, "{groupUid}", groupUid, -1), "{dateStr}", dateStr, -1)
}

func GetGiftOperateGroupUidWeek(groupUid string, dateStr string) string {
	return strings.Replace(strings.Replace(giftOperateGroupUidWeek, "{groupUid}", groupUid, -1), "{dateStr}", dateStr, -1)
}

func GetGiftOperateGroupUidMonth(groupUid string, monthStr string) string {
	return strings.Replace(strings.Replace(giftOperateGroupUidMonth, "{groupUid}", groupUid, -1), "{monthStr}", monthStr, -1)
}

func GetGiftOperateReceiveGroupUidDay(groupUid string, dateStr string) string {
	return strings.Replace(strings.Replace(giftOperateReceiveGroupUidDay, "{groupUid}", groupUid, -1), "{dateStr}", dateStr, -1)
}

func GetGiftOperateReceiveGroupUidWeek(groupUid string, dateStr string) string {
	return strings.Replace(strings.Replace(giftOperateReceiveGroupUidWeek, "{groupUid}", groupUid, -1), "{dateStr}", dateStr, -1)
}

func GetGiftOperateReceiveGroupUidMonth(groupUid string, monthStr string) string {
	return strings.Replace(strings.Replace(giftOperateReceiveGroupUidMonth, "{groupUid}", groupUid, -1), "{monthStr}", monthStr, -1)
}

func GetGiftOperateDay(dateStr string) string {
	return strings.Replace(giftOperateDay, "{dateStr}", dateStr, -1)
}

func GetGiftOperateWeek(weekStr string) string {
	return strings.Replace(giftOperateWeek, "{weekStr}", weekStr, -1)
}

func GetGiftOperateMonth(monthStr string) string {
	return strings.Replace(giftOperateMonth, "{monthStr}", monthStr, -1)
}

func GetGiftOperateSendUserIdDay(dateStr string) string {
	return strings.Replace(giftOperateSendUserIdDay, "{dateStr}", dateStr, -1)
}

func GetGiftOperateSendUserIdWeek(weekStr string) string {
	return strings.Replace(giftOperateSendUserIdWeek, "{weekStr}", weekStr, -1)
}

func GetGiftOperateSendUserIdMonth(monthStr string) string {
	return strings.Replace(giftOperateSendUserIdMonth, "{monthStr}", monthStr, -1)
}

func GetGiftOperateReceiveUserIdDay(dateStr string) string {
	return strings.Replace(giftOperateReceiveUserIdDay, "{dateStr}", dateStr, -1)
}

func GetGiftOperateReceiveUserIdWeek(weekStr string) string {
	return strings.Replace(giftOperateReceiveUserIdWeek, "{weekStr}", weekStr, -1)
}

func GetGiftOperateReceiveUserIdMonth(monthStr string) string {
	return strings.Replace(giftOperateReceiveUserIdMonth, "{monthStr}", monthStr, -1)
}

func GetGiftOperate1HourDurationGroupId(groupUid string) string {
	return strings.Replace(giftOperate1HourDurationGroupId, "{groupUid}", groupUid, -1)
}

func GetLuckyboxUserSum(sunday string) string {
	return strings.Replace(luckyboxUserSumSunday, "{sunday}", sunday, -1)
}

func GetLuckyboxPoolSum(sunday string) string {
	return strings.Replace(luckyboxPoolSumSunday, "{sunday}", sunday, -1)
}

func GetMicInfoChange() string {
	return micInfoChange
}

func GetMicInUserTemp(userExternalIds string) string {
	return strings.Replace(micInUserTemp, "{userExternalIds}", userExternalIds, -1)
}

func GetVideoMinuteCronCheck(uuid string) string {
	return strings.Replace(videoMinuteCronCheck, "{uuid}", uuid, -1)
}

func GetVideoMinuteCronDeal(uuid string) string {
	return strings.Replace(videoMinuteCronDeal, "{uuid}", uuid, -1)
}

func GetVideoMinuteCronEnd(videoUid string) string {
	return strings.Replace(videoMinuteCronEnd, "{videoUid}", videoUid, -1)
}

/*func GetVideoNextMinute() string {
	return videoNextMinute
}*/
