package route

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mylogrus"
	"github.com/gin-gonic/gin"
	ginSwagger "github.com/swaggo/gin-swagger"
	"github.com/swaggo/gin-swagger/swaggerFiles"
	"hilo-group/_const/enum/mgr_e"
	_ "hilo-group/docs"
	"hilo-group/domain/model/mgr_m"
	"hilo-group/route/charge_r"
	"hilo-group/route/group_power_r"
	"hilo-group/route/group_r"
	"hilo-group/route/mic_r"
)

func InitRouter() *gin.Engine {
	var r = gin.Default()

	r.GET("/group-swagger/*any", ginSwagger.WrapHandler(swaggerFiles.Handler))

	needLogin := r.Group("")
	needLogin.Use(ExceptionHandle, LoggerHandle, JWTApiHandle)
	v1 := needLogin.Group("/v1")
	imGroup := v1.Group("/imGroup")
	{
		imGroup.GET("/popular", wrapper(group_r.GetPopularGroups))
		imGroup.GET("/latest", wrapper(group_r.GetLatestGroups))
		imGroup.GET("/recommended", wrapper(group_r.GetRecommendGroup))
		//
		imGroup.POST("/group", wrapper(group_r.CreateGroup))
		imGroup.DELETE("/group/:groupId", wrapper(group_r.DestroyGroup))
		imGroup.GET("/group/:code", EncryptHandle, wrapper(group_r.GetGroupInfo))
		imGroup.GET("/detail/:groupId", EncryptHandle, wrapper(group_r.GetGroupDetail))
		imGroup.PUT("/group/:groupId", wrapper(group_r.ModifyGroupInfo))
		imGroup.GET("/search/:code", wrapper(group_r.SearchGroup))
		imGroup.DELETE("/member/:groupId", wrapper(group_r.LeaveGroup))
		imGroup.PUT("/permanent/:groupId", wrapper(group_r.AddPermanentMember))
		imGroup.DELETE("/permanent/:groupId", wrapper(group_r.RemovePermanentMember))
		imGroup.GET("/permanent/:groupId", wrapper(group_r.GetPermanentMember))
		imGroup.GET("/myRecent", wrapper(group_r.GetRecentGroup))
		imGroup.GET("/myPermanent", wrapper(group_r.GetMyGroup))
		//
		imGroup.GET("/visitors/:groupId", wrapper(group_r.GetGroupVisitorsV2))
		imGroup.GET("/visitors2/:groupId", wrapper(group_r.GetGroupVisitors)) // 自测用,跟上面的反过来
		imGroup.GET("/ownPublicGroup/:userExternalId", wrapper(group_r.GetOwnPublicGroup))
		//// 2.19的新接口
		imGroup.GET("/ownGroup", wrapper(group_r.GetOwnGroup))
		imGroup.GET("/theirGroup/:userExternalId", wrapper(group_r.GetTheirGroups))
		imGroup.PUT("/pluginReady/:groupId", wrapper(group_r.PluginReady))
		imGroup.GET("/roomInfo/:groupId", EncryptHandle, wrapper(group_r.GetRoomInfo)) // 进房
		//
		imGroup.GET("/password/:groupId", wrapper(group_r.GetGroupPassword))
		imGroup.GET("/role/:groupId", wrapper(group_r.GetGroupRole))
		imGroup.PUT("/role/:groupId", wrapper(group_r.SetGroupRole))
		imGroup.POST("/role/accept", wrapper(group_r.AcceptMemberInvite))
		imGroup.GET("/admin/:groupId", wrapper(group_r.GetGroupAdmin))
		//
		imGroup.PUT("/blacklist/:groupId", wrapper(group_r.AddGroupBlacklist))
		imGroup.DELETE("/blacklist/:groupId", wrapper(group_r.RemoveGroupBlacklist))
		imGroup.GET("/blacklist/:groupId", wrapper(group_r.GetGroupBlacklist))
		imGroup.PUT("/kick/:groupId", wrapper(group_r.KickGroupMembers))
		//
		imGroup.PUT("/allGroupMsg", wrapper(group_r.SendTextMsg))
		//
		imGroup.PUT("/welcomeText/:groupId", wrapper(group_r.SetWelcomeText))
		imGroup.GET("/support/page/:groupId", wrapper(group_r.GetSupportPage))
		imGroup.GET("/support/detail", wrapper(group_r.GetSupportDetail))
		imGroup.GET("/support/award/:groupId", wrapper(group_r.TryAddSupporter))
		imGroup.POST("/support/award/:groupId", wrapper(group_r.TakeSupportAward))
		//
		//// 操作类，普通用户不用
		imGroup.PUT("/memberLimit", wrapper(group_r.SetGroupMemberLimit))
		imGroup.PUT("/info/reset", wrapper(group_r.ResetGroupInfo), OperationLog)
		imGroup.PUT("/upgrade", wrapper(group_r.UpgradeGroup))
		imGroup.PUT("/downgrade", wrapper(group_r.DowngradeGroup))
		//
		imGroup.GET("/mic/all", wrapper(group_r.GroupMicAllInfoFive))
		imGroup.GET("/mic/all/type", wrapper(group_r.GroupMicAllInfoTen))
		imGroup.GET("/mic/all/type/new", wrapper(group_r.GroupMicAllInfoType))
		imGroup.PUT("/mic/num", wrapper(group_r.GroupMicNumChange))
		imGroup.GET("/mic/num", wrapper(group_r.GroupMicNum))
		imGroup.POST("/mic/emoji/msg", wrapper(group_r.GroupSendMicSystemMsg))
		imGroup.POST("/mic/in/invite/dialog", wrapper(group_r.GroupMicInInviteDialog))
		imGroup.POST("/mic/task/invite/dialog", wrapper(group_r.GroupMicTaskInviteDialog))
		imGroup.POST("/mic/in", wrapper(group_r.GroupMicIn))
		imGroup.POST("/mic/invite", wrapper(group_r.GroupMicInvite))
		imGroup.POST("/mic/leave", wrapper(group_r.GroupMicLeave))
		imGroup.POST("/mic/lock", wrapper(group_r.GroupMicLock))
		imGroup.POST("/mic/unlock", wrapper(group_r.GroupMicUnLock))
		imGroup.POST("/mic/speech/open", wrapper(group_r.GroupMicSpeechOpen))
		imGroup.POST("/mic/speech/close", wrapper(group_r.GroupMicSpeechClose))
		imGroup.POST("/mic/mute", wrapper(group_r.GroupMicMute))
		imGroup.POST("/mic/unmute", wrapper(group_r.GroupMicUnmute))
		imGroup.PUT("/in", wrapper(group_r.GroupIn)) // 进房
		imGroup.POST("/leave", wrapper(group_r.GroupLeave))
		imGroup.POST("/kick", wrapper(group_r.GroupKick))
		imGroup.PUT("/user/msg/status", wrapper(group_r.GroupUserMsg))
		imGroup.POST("/report", wrapper(group_r.GroupReport))
		imGroup.GET("/banner/list", wrapper(group_r.GroupBannerList))
		imGroup.GET("/roomBanners", wrapper(group_r.RoomBannerList))
		imGroup.PUT("/roomBanners", wrapper(group_r.NotifyRoomBannerListChange))
		//imGroup.POST("/mic/gift", wrapper(GroupMicGift)) // todo 先留在biz,内容有点多
		imGroup.POST("/mic/mass", wrapper(group_r.GroupMicMass))
		imGroup.POST("/mgr/mass", wrapper(group_r.GroupMgrMass))
		imGroup.POST("/mgr/clearScreen", wrapper(group_r.GroupMgrClearScreen))
		imGroup.GET("/online/users", wrapper(group_r.GroupInUsers))
		imGroup.GET("/online/users/new", wrapper(group_r.GroupInUserNew))
		imGroup.GET("/country", wrapper(group_r.GetGroupByCountryV2))
		imGroup.GET("/country/prior", wrapper(group_r.GroupountryPrior))
		//
		imGroup.POST("/theme/custom", wrapper(group_r.GroupThemeAdd))
		imGroup.GET("/theme/custom/config", wrapper(group_r.GroupThemeConfig))
		imGroup.PUT("/theme/custom/using", wrapper(group_r.GroupThemeUsing))
		imGroup.GET("/theme/custom/all", wrapper(group_r.GroupThemeValidAll))
		//
		imGroup.GET("/medal/all", wrapper(group_r.GroupMedalAll))
		imGroup.GET("/medal/room", wrapper(group_r.GetRoomMedal))
	}

	groupPower := v1.Group("/groupPower")
	{
		groupPower.POST("/user", wrapper(group_power_r.GroupPowerJoin))
		groupPower.DELETE("/user/:groupPowerId", wrapper(group_power_r.GroupPowerLeave))
		groupPower.GET("/title/:groupPowerId", wrapper(group_power_r.GetGroupPowerTitle))
		groupPower.GET("/group/:groupPowerId", wrapper(group_power_r.GetGroupPowerGroups))
		groupPower.GET("/team", wrapper(group_power_r.GroupPowerTeam))
		groupPower.GET("/billboard/week", wrapper(group_power_r.GroupPowerBillboardWeek))
		groupPower.GET("/billboard/owner/week", wrapper(group_power_r.GroupPowerBillboardOwnerWeek))
		groupPower.GET("/info", wrapper(group_power_r.GroupPowerInfo))
		groupPower.GET("/rooms", wrapper(group_power_r.GroupPowerRooms))
		groupPower.GET("/members", wrapper(group_power_r.GroupPowerMembers))
		groupPower.POST("/apply", wrapper(group_power_r.GroupPowerApplyJoin))
		groupPower.POST("/apply/pass", wrapper(group_power_r.GroupPowerApplyPass))
		groupPower.GET("/apply/list", wrapper(group_power_r.GroupPowerApplyList))
		groupPower.GET("/apply/count", wrapper(group_power_r.GroupPowerApplyCount))
		groupPower.POST("/quit", wrapper(group_power_r.GroupPowerQuit))
		groupPower.GET("/quit/list", wrapper(group_power_r.GroupPowerQuitList))
		groupPower.POST("/admin", wrapper(group_power_r.GroupPowerSetAdmin))
		groupPower.GET("/rank/:period", wrapper(group_power_r.GroupPowerRank))
		groupPower.GET("/rankTop", wrapper(group_power_r.GroupPowerRankTop))
		groupPower.GET("/star", wrapper(group_power_r.GroupPowerStar))
		groupPower.GET("/star/:period", wrapper(group_power_r.GroupPowerStarPeriod))
		groupPower.POST("/info/set", wrapper(group_power_r.GroupPowerSetInfo))
	}
	h5GroupPower := v1.Group("/h5/groupPower")
	{
		h5GroupPower.GET("/grade/detail", wrapper(group_power_r.GroupPowerGradeDetail))
		h5GroupPower.GET("/rank/month", wrapper(group_power_r.GroupPowerMonthRankAct))
	}

	charge := v1.Group("/charge")
	{
		charge.GET("/share", wrapper(charge_r.CanShareChargeLink))
	}

	// 内部接口
	inner := r.Group("/inner")
	innerGroupPower := inner.Group("/groupPower")
	{
		innerGroupPower.GET("/infos", wrapper(group_power_r.MGetGroupPowers))
	}
	innerMic := inner.Group("/mic")
	{
		innerMic.GET("/onMicSeconds", wrapper(mic_r.MGetUserOnMicSeconds))
		innerMic.GET("/onMicSeconds/range", wrapper(mic_r.MGetUserOnMicSecondsRange))
	}
	r.GET("/test", wrapper(group_power_r.Test))
	return r
}

// 操作日志
func OperationLog(c *gin.Context) {
	mylogrus.MyLog.Infof("%v-%v", c.Request.Method, c.FullPath())
	// 处理请求
	c.Next()
	model := domain.CreateModelNil()
	operConfig := mgr_m.GetOperationModuleUrl(model, c.Request.Method, c.FullPath())
	if operConfig.ID > 0 {
		// 需要记录操作日志
		if data, ok := c.Get(mgr_e.OperationLogKey); ok {
			if log, ok := data.(mgr_m.MgrOperationLog); ok {
				log.ModuleId = operConfig.ModuleId
				log.ModuleUrlId = operConfig.ID
				if err := mgr_m.SaveOperationLog(model, log); err != nil {
					model.Log.Error("SaveOperationLog fail:%v", err.Error())
				}
			}
		}
	}
}
