package groupPower_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

type GroupPowerExpRank struct {
	GroupPowerId mysql.ID
	Exp          mysql.Num
	Rank         int
}

// 获取家族经验排行榜
// param limit: 排行榜人数
func GetGroupPowerExpRank(model *domain.Model, beginDate, endDate string, limit int) ([]GroupPowerExpRank, error) {
	var res []GroupPowerExpRank
	if err := model.DB().Table("group_power_day_exp").Select("group_power_id,SUM(exp) as exp").
		Where("date BETWEEN ? AND ?", beginDate, endDate).Group("group_power_id").Order("exp DESC").Limit(limit).Find(&res).Error; err != nil {
		model.Log.Errorf("GetGroupPowerExpRank fail:%v", err)
		return res, err
	}
	for i := range res {
		res[i].Rank = i + 1
	}
	return res, nil
}
