package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/_const/enum/group_e"
	"time"
)

//群与人,
//设定（用户的当前状态）
type GroupUser struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	GroupId       mysql.Str
	UserId        mysql.ID
	MsgStatus     group_e.MsgStatusGroupUser
	InRoomTime    *time.Time //进入房间的时间
}

func (groupUser *GroupUser) MsgStatusNormal() *GroupUser {
	groupUser.MsgStatus = group_e.NormalMsgStatusGroupUser
	return groupUser
}

func (groupUser *GroupUser) MsgStatusMute() *GroupUser {
	groupUser.MsgStatus = group_e.MuteMsgStatusGroupUser
	return groupUser
}

func (groupUser *GroupUser) MsgStatusDoNotDisturb() *GroupUser {
	groupUser.MsgStatus = group_e.DoNotDisturbMsgStatusGroupUser
	return groupUser
}

//删除
func (groupUser *GroupUser) Del() *GroupUser {
	groupUser.SetDel()
	return groupUser
}

//修改进入房间的时间
func (groupUser *GroupUser) SetRoomInTime() *GroupUser {
	now := time.Now()
	groupUser.InRoomTime = &now
	return groupUser
}

func (groupUser *GroupUser) Get() (map[string]group_e.MsgStatusGroupUser, error) {
	rows := make([]GroupUser, 0)
	err := groupUser.Db.Where(groupUser).Find(&rows).Error
	if err != nil {
		return nil, err
	}
	result := make(map[string]group_e.MsgStatusGroupUser, 0)
	for _, i := range rows {
		result[i.GroupId] = i.MsgStatus
	}
	return result, nil
}

func (groupUser *GroupUser) Delete() error {
	return groupUser.Db.Where(groupUser).Delete(&GroupUser{}).Error
}
