package group_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
)

// 群欢迎语
type GroupWelcomeText struct {
	mysql.Entity
	GroupId mysql.Str
	UserId  mysql.ID
	Text    mysql.Str
}

func (gwt *GroupWelcomeText) Save(db *gorm.DB) error {
	return db.Clauses(clause.OnConflict{
		Columns:   []clause.Column{{Name: "group_id"}},
		DoUpdates: clause.AssignmentColumns([]string{"text", "user_id"}),
	}).Create(gwt).Error
}

func (gwt *GroupWelcomeText) Remove(db *gorm.DB, groupId string, userId uint64) error {
	cond := GroupWelcomeText{GroupId: groupId, UserId: userId}
	return db.Where(&cond).Delete(gwt).Error
}

func (gwt *GroupWelcomeText) Get(db *gorm.DB) (*GroupWelcomeText, error) {
	rows := make([]GroupWelcomeText, 0)
	err := db.Where(gwt).Find(&rows).Error
	if err != nil {
		return nil, err
	}
	if len(rows) <= 0 {
		return nil, nil
	}
	return &rows[0], nil
}

func RemoveWelcomeText(db *gorm.DB, groupId string) error {
	cond := GroupWelcomeText{GroupId: groupId}
	return db.Where(&cond).Delete(&GroupWelcomeText{}).Error
}
