package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/myerr"
)

//腾讯云的拉黑名单，临时表
type UserBlackTencentyunTmp struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserExternal  mysql.Str
	BlockExternal mysql.Str
}

//黑名单
type UserBlock struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	BlockUserId   mysql.ID
}

func initUserBlock(model *domain.Model, userId mysql.ID) *UserBlock {
	return &UserBlock{
		Model:  model,
		UserId: userId,
	}
}

//拉黑
func (ub *UserBlock) block(blockUserId mysql.ID) (*UserBlock, error) {
	err := ub.Db.Where(&UserBlock{
		UserId:      ub.UserId,
		BlockUserId: blockUserId,
	}).First(ub).Error
	//已经拉黑了
	if err == nil {
		ub.SetLasyLoad()
		return ub, nil
		//return nil, myerr.NewWaring("已经标记拉黑")
	} else if err == gorm.ErrRecordNotFound {
		ub.BlockUserId = blockUserId
		return ub, nil
	} else {
		return nil, myerr.WrapErr(err)
	}
}

//取消拉黑
func (ub *UserBlock) blockCancel(blockUserId mysql.ID) (*UserBlock, error) {
	err := ub.Db.Where(&UserBlock{
		UserId:      ub.UserId,
		BlockUserId: blockUserId,
	}).First(ub).Error
	//
	if err == nil {
		ub.SetDel()
		return ub, nil
	} else if err == gorm.ErrRecordNotFound {
		return nil, myerr.NewWaring("没有拉黑的记录")
	} else {
		return nil, myerr.WrapErr(err)
	}
}

//检查是否存在拉黑
/*func CheckBlock(model *domain.Model, userId mysql.ID, blockUserId mysql.ID) (bool, error) {
	var n int64
	if err := model.Db.Model(&UserBlock{}).Where(&UserBlock{
		UserId:      userId,
		BlockUserId: blockUserId,
	}).Count(&n).Error; err != nil {
		return false, myerr.WrapErr(err)
	}
	return n > 0, nil
}*/

//检查是否存在拉黑（无论是我拉黑别人，还是别人拉黑我）, true:拉黑， false:不拉黑
func CheckBlockOr(model *domain.Model, userId mysql.ID, blockUserId mysql.ID) (bool, error) {
	var n int64
	if err := model.Db.Model(&UserBlock{}).Where(&UserBlock{
		UserId:      userId,
		BlockUserId: blockUserId,
	}).Count(&n).Error; err != nil {
		return false, myerr.WrapErr(err)
	}
	if n == 0 {
		if err := model.Db.Model(&UserBlock{}).Where(&UserBlock{
			BlockUserId: userId,
			UserId:      blockUserId,
		}).Count(&n).Error; err != nil {
			return false, myerr.WrapErr(err)
		}
	}
	return n > 0, nil
}

func CheckBlock(model *domain.Model, userId mysql.ID, blockUserId mysql.ID) (bool, error) {
	var n int64
	if err := model.Db.WithContext(model).Model(&UserBlock{}).Where(&UserBlock{
		UserId:      userId,
		BlockUserId: blockUserId,
	}).Count(&n).Error; err != nil {
		return false, myerr.WrapErr(err)
	}
	return n > 0, nil
}

//检查互相拉黑的成员
func FilterBlock(model *domain.Model, userId mysql.ID, otherUserIds []mysql.ID) ([]mysql.ID, error) {
	if len(otherUserIds) == 0 {
		return otherUserIds, nil
	}
	userBlocks1 := []UserBlock{}
	if err := model.Db.Model(&UserBlock{}).Where(&UserBlock{
		UserId: userId,
	}).Where("block_user_id in (?)", otherUserIds).Find(&userBlocks1).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	userBlocks2 := []UserBlock{}
	if err := model.Db.Model(&UserBlock{}).Where(&UserBlock{
		BlockUserId: userId,
	}).Where("user_id in (?)", otherUserIds).Find(&userBlocks2).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}

	blockSet := map[uint64]struct{}{}
	for i, _ := range userBlocks1 {
		blockSet[userBlocks1[i].BlockUserId] = struct{}{}
	}
	for i, _ := range userBlocks2 {
		blockSet[userBlocks2[i].UserId] = struct{}{}
	}

	//
	resultUserIds := make([]mysql.ID, 0, len(otherUserIds))
	for i, r := range otherUserIds {
		if _, flag := blockSet[r]; !flag {
			resultUserIds = append(resultUserIds, otherUserIds[i])
		}
	}
	return resultUserIds, nil
}

// 获取用户拉黑的用户ids
func GetBlockUserIds(model *domain.Model, userId mysql.ID) ([]mysql.ID, error) {
	var userBlocks []UserBlock
	if err := model.Db.Where(&UserBlock{
		UserId: userId,
	}).Find(&userBlocks).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	var userIds []mysql.ID
	for _, v := range userBlocks {
		userIds = append(userIds, v.BlockUserId)
	}
	return userIds, nil
}