package groupPower_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/myerr"
	"time"
)

type GroupPowerInviteJoin struct {
	Id           uint64    `json:"id"`
	UserId       uint64    `json:"user_id"`
	GroupPowerId uint64    `json:"group_power_id"`
	CreatedTime  time.Time `json:"created_time"`
	UpdatedTime  time.Time `json:"updated_time"`
	InviteUserId uint64    `json:"invite_user_id"`
	IsAccept     int8      `json:"is_accept"`
}

func InsertGroupPowerInviteJoin(userId, inviteUserId, familyId uint64) error {
	nowTime := time.Now()
	sql := "insert into group_power_invite_join(user_id,invite_user_id,group_power_id,is_accept,created_time,updated_time) " +
		"value(?,?,?,?,?,?) on duplicate key update is_accept=?,created_time=?,updated_time=?"
	err := mysql.Db.Exec(sql, userId, inviteUserId, familyId, 0, nowTime, nowTime, 0, nowTime, nowTime).Error
	if err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func GetGroupPowerInviteJoin(userId, familyId uint64) (*GroupPowerInviteJoin, error) {
	res := new(GroupPowerInviteJoin)
	err := mysql.Db.Where(GroupPowerInviteJoin{UserId: userId, GroupPowerId: familyId}).Where("is_accept=0").First(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return res, nil
}

func AcceptGroupPowerInviteJoin(userId, familyId uint64) error {
	err := mysql.Db.Exec("update group_power_invite_join set is_accept = 1 where user_id=? and group_power_id=?", userId, familyId).Error
	if err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}
