package match_e

import "git.hilo.cn/hilo-common/resource/mysql"

/****************************/
type MatchDetailDataChange mysql.NumAll

const (
	AddDataChange    MatchDetailDataChange = 1
	ReduceDataChange MatchDetailDataChange = 2
	ZeroDataChange   MatchDetailDataChange = 0
)

/******元素分数***************/
/*type EnumCountType mysql.Type

const (
	PriorityEnumCountType  EnumCountType = 1
	ExcellentEnumCountType EnumCountType = 2
	RelationEnumCountType  EnumCountType = 3
)*/

/*const (
	//接收到礼物的数量
	ReceiveGiftNumCountType EnumCountType = 1
	//接收到礼物的频率
	ReceiveGiftFCountType EnumCountType = 2
	//被举报
	BeReportCountType EnumCountType = 3
	//被拉黑
	BeBlackCountType EnumCountType = 4
	//支付次数
	PayCountType EnumCountType = 5
	//被喜欢的次数
	LikeMeType EnumCountType = 6
	//新用户
	NewUserType EnumCountType = 7
	//连续被拒
	AgainRefuse EnumCountType = 8
	//每天新登陆用户
	DailyUserType EnumCountType = 9
	//活跃等级
	ActiveGrade EnumCountType = 10
	//连续同性
	AgainSameSex EnumCountType = 11
	//匹配推送次数
	MatchSuccessNum EnumCountType = 12
	//匹配推送接受次数
	MatchConfirmNum EnumCountType = 13
	//接通率
	MatchConfirmRate EnumCountType = 14
	//免费加时
	MatchFreeTimeNum EnumCountType = 15
	//礼物加时
	MatchGiftTimeNum EnumCountType = 16
	//加时率
	MatchAddTimeRate EnumCountType = 17
	//工会成员
	TradeUnion EnumCountType = 18
	//匹配拒绝
	RelationMatchRefuse EnumCountType = 19
	//匹配用户
	RelationMatchUser EnumCountType = 20
)*/

//优先度排序
type PriorityUserFormOriginType mysql.Type

const (
	//钻石余额
	PriorityDiamond PriorityUserFormOriginType = 1
	//首充
	PriorityFirstCharge PriorityUserFormOriginType = 2
	//财富等级
	PriorityWealthGrade PriorityUserFormOriginType = 3
	//被举报
	PriorityBeReport PriorityUserFormOriginType = 4
	//被拉黑
	PriorityBeBlack PriorityUserFormOriginType = 5
	//近期充值
	PriorityRecentlyPay PriorityUserFormOriginType = 6
	//新用户
	PriorityNewUserType PriorityUserFormOriginType = 7
	//连续被拒
	PriorityAgainRefuse PriorityUserFormOriginType = 8
	//每天新登陆用户
	PriorityDailyUserType PriorityUserFormOriginType = 9
	//活跃等级
	PriorityActiveGrade PriorityUserFormOriginType = 10
	//工会
	PriorityTradeUnion PriorityUserFormOriginType = 11
	//多次匹配到同性
	PriorityAgainSameSex PriorityUserFormOriginType = 12
)

//
var PriorityMap = map[PriorityUserFormOriginType]string{
	PriorityDiamond:       "钻石余额",
	PriorityFirstCharge:   "首充",
	PriorityWealthGrade:   "财富等级",
	PriorityBeReport:      "被举报",
	PriorityBeBlack:       "被拉黑",
	PriorityRecentlyPay:   "近期充值",
	PriorityNewUserType:   "新用户",
	PriorityAgainRefuse:   "连续被拒",
	PriorityDailyUserType: "每天新登陆用户",
	PriorityActiveGrade:   "活跃等级",
	PriorityTradeUnion:    "工会",
	PriorityAgainSameSex:  "连续同性",
}

//质量排序
type ExcellentUserFormOriginType mysql.Type

const (
	//被喜欢的次数
	ExcellentLikeMe ExcellentUserFormOriginType = 1
	//接收礼物数量
	ExcellentReceiveGiftNumChange ExcellentUserFormOriginType = 2
	//接收礼物次数
	ExcellentReceiveGiftFChange ExcellentUserFormOriginType = 3
	//被投诉次数
	ExcellentBeReport ExcellentUserFormOriginType = 4
	//被拉黑的次数
	ExcellentBeBlack ExcellentUserFormOriginType = 5
	//魅力等级
	ExcellentCharmGrade ExcellentUserFormOriginType = 6
	//被付费建立融云会话
	ExcellentSessionCreate ExcellentUserFormOriginType = 7
	//接通率
	ExcellentMatchConfirmRate ExcellentUserFormOriginType = 8
	//加时率（视频通话加时次数（免费加时成功 + 礼物加时成功）/视频通话次数(匹配成功的次数)）
	ExcellentAddTimeRate ExcellentUserFormOriginType = 9
	//工会成员
	ExcellentTradeUnion ExcellentUserFormOriginType = 10
	//匹配成功次数
	ExcellentMatchSuccessNum ExcellentUserFormOriginType = 11
	//匹配确认次数
	ExcellentMatchConfirmNum ExcellentUserFormOriginType = 12
	//匹配免费加时的次数
	ExcellentMatchFreeTimeNum ExcellentUserFormOriginType = 13
	//匹配礼物加时次数
	ExcellentMatchGiftTimeNum ExcellentUserFormOriginType = 14
)

var ExcellentMap = map[ExcellentUserFormOriginType]string{
	ExcellentLikeMe:               "喜欢我",
	ExcellentReceiveGiftNumChange: "接收礼物数量",
	ExcellentReceiveGiftFChange:   "接收礼物次数",
	ExcellentBeReport:             "被投诉次数",
	ExcellentBeBlack:              "被拉黑次数",
	ExcellentCharmGrade:           "魅力等级",
	ExcellentSessionCreate:        "被付费建立融云会话",
	ExcellentMatchConfirmRate:     "接通率",
	ExcellentAddTimeRate:          "加时率",
	ExcellentTradeUnion:           "工会成员",
	ExcellentMatchSuccessNum:      "匹配成功次数",
	ExcellentMatchConfirmNum:      "匹配确认次数",
	ExcellentMatchFreeTimeNum:     "匹配免费加时次数",
	ExcellentMatchGiftTimeNum:     "匹配礼物加时次数",
}

//关系排序
type RelationUserFormOriginType mysql.Type

const (
	//喜欢的用户
	RelationUserLike RelationUserFormOriginType = 1
	//匹配拒绝用户
	RelationMatchRefuse RelationUserFormOriginType = 2
	//匹配过的用户
	RelationMatchUser RelationUserFormOriginType = 3
	//付费发送过消息但没进行过视频聊天
	RelationSessionNoMatchConfirm RelationUserFormOriginType = 4
	//上一次匹配的用户
	RelationMatchUserLastTime RelationUserFormOriginType = 5
)

var RelationMap = map[RelationUserFormOriginType]string{
	RelationUserLike:              "喜欢的用户",
	RelationMatchRefuse:           "匹配被拒绝",
	RelationMatchUser:             "匹配上的用户",
	RelationSessionNoMatchConfirm: "付费发送过消息但没进行过视频聊天",
	RelationMatchUserLastTime:     "上一次匹配的用户",
}

/******匹配确认***********************************/
type MatchConfirmStatus mysql.Type

const (
	Success MatchConfirmStatus = 1
	Fail    MatchConfirmStatus = 2
	Temp    MatchConfirmStatus = 3
)

type MatchConfirmUserAcceptRefuse mysql.Type

const (
	AcceptMatchConfirmUser MatchConfirmUserAcceptRefuse = 1
	RefuseMatchConfirmUser MatchConfirmUserAcceptRefuse = 2
)

type MatchCharmUserScoreDetailType = mysql.Type

const (
	GiftReceiveCharmType    MatchCharmUserScoreDetailType = 1
	GiftReceiveVipCharmType MatchCharmUserScoreDetailType = 2
)

type MatchWealthUserScoreDetailType = mysql.Type

const (
	GiftReceiveWealthType    MatchWealthUserScoreDetailType = 1
	GiftReceiveVipWealthType MatchWealthUserScoreDetailType = 2
)

