package bean_e

import "git.hilo.cn/hilo-common/resource/mysql"

type StatusAccount = mysql.Type

const (
	Normal StatusAccount = 1
	//冻结，只是限制减少，不限制增加
	Frozen StatusAccount = 2
)

type OperateType = mysql.Type

const (
	//接受礼物
	ReceiveGift OperateType = 1
	//钻石兑换
	DiamondExchange OperateType = 2
	//管理人删除
	MgrReduce OperateType = 3
	//1对1视频收益
	VideoMinute OperateType = 4
	//匹配送礼物加时间
	MatchTime OperateType = 5
	//MatchGift
	MatchGift OperateType = 6
	//VideoGift
	VideoGift OperateType = 7
	//视频时间获取豆子汇总
	VideoTimeTotal OperateType = 8

	// 粉钻相关
	PinkReceiveGift     OperateType = 9  // 收礼物得金币
	PinkDiamondExchange OperateType = 10 // 换成粉钻
	PinkMgrReduce       OperateType = 11 // 管理人扣减金币
	PinkVideoMinute     OperateType = 12 // 1对1视频金币收益（不显示）
	PinkMatchTime       OperateType = 13 // 匹配送粉钻礼物加时间
	PinkMatchGift       OperateType = 14 // 匹配粉钻礼物
	PinkVideoGift       OperateType = 15 // 1对1视频粉钻礼物
	PinkVideoTimeTotal  OperateType = 16 // 1对1(粉钻)时间汇总（显示）
)
