package luckyWheel_e

const LUCKY_WHEEL_SEAT_NUM = 10           // 轮盘座位数
const LUCKY_WHEEL_ROLL_TIME = 8           // 轮盘淘汰一个人需要的时间（秒）
const LUCKY_WHEEL_LAST_ROLL_TIME = 5      // 最后一轮出胜利者需要的时间（秒）
const LUCKY_WHEEL_SHOW_TIMELONG = 5       // 轮盘结束后真空期

const LUCKY_WHEEL_WINNER_PERCENTILE = 90      // 赢家分成比例
const LUCKY_WHEEL_OWNER_PERCENTILE = 5        // 群主分成比例

type LuckyWheelStatusType = uint8

const (
	NONE       LuckyWheelStatusType = 0 // 没有活动/已结束
	CREATED    LuckyWheelStatusType = 1 // 创建，等待用户加入
	ROLLING    LuckyWheelStatusType = 2 // 转动中
	SHOWING    LuckyWheelStatusType = 3 // 结果展示中
	RESTARTING LuckyWheelStatusType = 4 // 重启中
)

type LuckyWheelEndStatusType = uint8

const (
	DONE              LuckyWheelEndStatusType = 0 // 正常结束
	USER_CANCELED     LuckyWheelEndStatusType = 1 // 用户取消
	TIME_OUT_CANCELED LuckyWheelEndStatusType = 2 // 超时未开始结束
)
