package mgr_e

import "git.hilo.cn/hilo-common/resource/mysql"

type MgrType mysql.Type

const (
	//主账号
	MainAccountMgrType MgrType = 1
	//次账号
	SubAccountMgrType MgrType = 2
)

type ReportPageType mysql.Type

const (
	VedioPageType        ReportPageType = 1
	UserInfoPageType     ReportPageType = 2
	SessionPageType      ReportPageType = 3
	MatchHistroyPageType ReportPageType = 4
	GroupPageType        ReportPageType = 5
)

type ReportStatus mysql.Type

const (
	//未处理
	NoDealReportStatus ReportStatus = 1
	//已处理
	HasDealReportStatus ReportStatus = 2
)

type ReportReasonType mysql.Type

const (
	//语言骚扰
	VerbalHarassment ReportReasonType = 1
	Nudity           ReportReasonType = 2
	IndecentMsg      ReportReasonType = 3
	IndecentPic      ReportReasonType = 4
	//11.在多个房间骚扰 12.侵犯他人隐私 13.色情暴力内容 14.损害官方利益
)

//用户状态
type UserStatus mysql.Type

const (
	//正常
	NomalUserStatus UserStatus = 1
	//冻结
	FreezeUserStatus UserStatus = 2
)

//报告处理类型
type MgrDealType = mysql.Type

const (
	//忽略
	IgnoreDealType MgrDealType = 1
	//冻结24小时
	FreezeDealType24 MgrDealType = 2
	//冻结72小时
	FreezeDealType72 MgrDealType = 3
	//冻结30小时
	FreezeDealType720 MgrDealType = 4
	//冻结永久
	FreezeDealTypeForever MgrDealType = 10
	//解除封禁
	CancelFreezeDealType MgrDealType = 11
	//删除图片
	DelUserAvatar MgrDealType = 12
	//冻结7天（168小时）
	FreezeDealType168 MgrDealType = 13
)

var MgrDealTypeDesc = map[MgrDealType]string{
	FreezeDealType24:      "封锁24小时",
	FreezeDealType72:      "封锁72小时",
	FreezeDealType168:     "封锁7天",
	FreezeDealType720:     "封锁30天",
	FreezeDealTypeForever: "永久封锁",
}

//报告处理原因类型
type MgrDealReasonType = mysql.Type

const (
	//无
	None MgrDealReasonType = 1
	//色情性
	Pornographic MgrDealReasonType = 2
	//侮辱谩骂
	Insult MgrDealReasonType = 3
	//不尊重宗教
	Religion MgrDealReasonType = 4
	//恐怖活动
	Terrorism MgrDealReasonType = 5
	//违法违规
	BreakingLaw MgrDealReasonType = 6
	//宣传其它APP
	OtherApp MgrDealReasonType = 7
	// 在多个房间骚扰
	RoomBother MgrDealReasonType = 11
	// 侵犯他人隐私
	PrivacyBad MgrDealReasonType = 12
	// 色情暴力内容
	SexViolence MgrDealReasonType = 13
	// 损害官方利益
	OfficialEffect MgrDealReasonType = 14
)

var MgrDealReasonTypeDesc = map[MgrDealReasonType]string{
	Pornographic:   "色情性",
	Insult:         "侮辱谩骂",
	Religion:       "不尊重宗教",
	Terrorism:      "恐怖活动",
	BreakingLaw:    "违法违规",
	OtherApp:       "宣传其它APP",
	RoomBother:     "在多个房间骚扰",
	PrivacyBad:     "侵犯他人隐私",
	SexViolence:    "色情暴力内容",
	OfficialEffect: "损害官方利益",
}

type MgrOriginType = mysql.Type

const (
	//报告
	ReportOriginType MgrOriginType = 1
	//用户页面
	UserOriginType MgrOriginType = 2
)

//管理人钻石发放单子状态
type MgrSendDiamondBillStatus = mysql.Type

const (
	NoSend  MgrSendDiamondBillStatus = 1
	HasSend MgrSendDiamondBillStatus = 2
)

//管理人发钻石详情状态
type MgrSendDiamondBillDetailType = mysql.Type

const (
	//活动扶持
	ActivitySupport MgrSendDiamondBillDetailType = 1
	//活动奖励
	ActivityAward MgrSendDiamondBillDetailType = 2
)

type MgrSendDiamondBillDetailStatus = mysql.Type

const (
	//还没发奖
	NoSendDetailStatus MgrSendDiamondBillDetailStatus = 1
	//发奖成功
	SendSuccessDetailStatus MgrSendDiamondBillDetailStatus = 2
	//发奖失败
	SendFailDetailStatus MgrSendDiamondBillDetailStatus = 3
)

type OpenScreenType = mysql.Type

const (
	CommonOpenScreenType OpenScreenType = 0
	CpScreenType         OpenScreenType = 1
	WeekScreenType       OpenScreenType = 2
)

type TypeMgrImeiLog = mysql.Type

const (
	AddMgrImeiLog TypeMgrImeiLog = 1
	DelMgrImeiLog TypeMgrImeiLog = 2
)

var OperationLogKey = "operationLogKey"
