package group_power_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

//注册监听
var groupPowerUpgradeListen = new(domain.EventBase)

type GroupPowerUpgradeEvent struct {
	GroupPowerId mysql.ID
}

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddGroupPowerUpgradeSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(groupPowerUpgradeListen, callback)
}

//加入到异步操作中
func AddGroupPowerUpgradeAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(groupPowerUpgradeListen, callback)
}

//领域事件发布
func PublishGroupPowerUpgrade(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(groupPowerUpgradeListen, model, event)
}
