package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
)

type GroupBlacklist struct {
	mysql.Entity
	ImGroupId string
	UserId    uint64
	Imei      string
	Ip        string
}

func AddBlacklist(model *domain.Model, gb *GroupBlacklist) error {
	return model.Db.Create(gb).Error
}

func RemoveBlacklist(model *domain.Model, gb *GroupBlacklist) error {
	return model.Db.Where(gb).Delete(&GroupBlacklist{}).Error
}

func (g *GroupBlacklist) FindUser(model *domain.Model) error {
	return model.Db.Where(g).First(g).Error
}

func InGroupBlackList(model *domain.Model, groupId, imei, ip string, userId uint64) bool {
	g := GroupBlacklist{ImGroupId: groupId, UserId: userId}
	err := g.FindUser(model)
	if err == nil {
		return true
	}
	if imei != "" {
		g := GroupBlacklist{ImGroupId: groupId, Imei: imei}
		err := g.FindUser(model)
		if err == nil {
			return true
		}
	}
	if ip != "" {
		g := GroupBlacklist{ImGroupId: groupId, Ip: ip}
		err := g.FindUser(model)
		if err == nil {
			return true
		}
	}
	return false
}

func FindGroupBlackList(model *domain.Model, groupId string) ([]GroupBlacklist, error) {
	result := make([]GroupBlacklist, 0)
	err := model.Db.Where(&GroupBlacklist{ImGroupId: groupId}).Find(&result).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, err
		}
	}
	return result, nil
}
