package group_m

import "git.hilo.cn/hilo-common/domain"

type GroupPopular struct {
	GroupId string
}

func GetPopularWhiteList(model *domain.Model) (map[string]struct{}, error) {
	rows := make([]GroupPopular, 0)
	err := model.Db.Find(&rows).Error
	if err != nil {
		return nil, err
	}

	result := make(map[string]struct{}, 0)
	for _, i := range rows {
		result[i.GroupId] = struct{}{}
	}
	return result, nil
}

func (gp *GroupPopular) Add(model *domain.Model) error {
	return model.Db.Create(gp).Error
}

func (gp *GroupPopular) Delete(model *domain.Model) error {
	return model.Db.Where(gp).Delete(&GroupPopular{}).Error
}