package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/myerr"
)

func AddGroupKickRecord(model *domain.Model, imGroupId string, userId mysql.ID, beKickUserId mysql.ID) error {
	groupKickRecord := GroupKickRecord{
		Model:        model,
		ImGroupId:    imGroupId,
		UserId:       userId,
		BeKickUserId: beKickUserId,
	}
	if err := model.Db.Create(&groupKickRecord).Error; err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

