package group_m

import (
	"context"
	"git.hilo.cn/hilo-common/resource/redisCli"
	redis2 "github.com/go-redis/redis/v8"
	"hilo-group/_const/redis_key"
	"hilo-group/domain/model"
	"hilo-group/myerr"
)

func (groupMsg *GroupMsg) Persistent() error {
	if err := model.Persistent(groupMsg.Db, groupMsg); err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func (groupUser *GroupUser) Persistent() error {
	if err := model.Persistent(groupUser.Db, groupUser); err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func (rediGroupMsgSeqMax *RediGroupMsgSeqMax) Persistent() error {
	if err := redisCli.GetRedis().HSet(context.Background(), redis_key.GetPrefixGroupMsgSeqMaxAll(), rediGroupMsgSeqMax.GroupUuid, rediGroupMsgSeqMax.Seq).Err(); err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func (redisGroupMsgSeqMaxUser *RedisGroupMsgSeqMaxUser) Persistent() error {
	if err := redisCli.GetRedis().HSet(context.Background(), redis_key.GetPrefixGroupMsgSeqMaxGroup(redisGroupMsgSeqMaxUser.GroupUuid), redisGroupMsgSeqMaxUser.GroupUuid+"_"+redisGroupMsgSeqMaxUser.ExternalId, redisGroupMsgSeqMaxUser.Seq).Err(); err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func (redisGroupMsgDurationScore *RedisGroupMsgDurationScore) Persistent() error {
	if redisGroupMsgDurationScore.AddCountUser != 0 {
		if err := redisCli.GetRedis().ZIncrBy(context.Background(), redis_key.GetPrefixGroupMsgDurationScore(), float64(redisGroupMsgDurationScore.AddCountUser), redisGroupMsgDurationScore.GroupUuid).Err(); err != nil {
			return err
		}
	}
	return nil
}

func (redisGroupUserMsgDuration *RedisGroupMsgDurationUser) Persistent() (int64, error) {
	if i, err := redisCli.GetRedis().ZAdd(context.Background(), redis_key.GetPrefixGroupMsgDurationUser(), &redis2.Z{
		Score:  float64(redisGroupUserMsgDuration.TimeStamp),
		Member: redisGroupUserMsgDuration.GroupUuid + "_" + redisGroupUserMsgDuration.ExternalId,
	}).Result(); err != nil {
		return i, err
	} else {
		return i, nil
	}
}

func (groupSupportAwardAdmin *GroupSupportAwardAdmin) Persistent() error {
	if err := model.Persistent(groupSupportAwardAdmin.Db, groupSupportAwardAdmin); err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func (groupSupportAwardMgr *GroupSupportAwardMgr) Persistent() error {
	if err := model.Persistent(groupSupportAwardMgr.Db, groupSupportAwardMgr); err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func (groupSupportResult *GroupSupportResult) Persistent() error {
	if err := model.Persistent(groupSupportResult.Db, groupSupportResult); err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func (groupCustomTheme *GroupCustomTheme) Persistent() error {
	if err := model.Persistent(groupCustomTheme.Db, groupCustomTheme); err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func (groupMedal *GroupMedal) Persistent() error {
	if err := model.Persistent(groupMedal.Db, groupMedal); err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

//func (micUser *MicUser) Persistent() error {
//	//map 结构 key:groupUuid key:i value:123_0
//	if micUser.UserId == nil {
//		//下麦
//		//redis + lua 集成多个命令来保证原子性 或者 用 Multi EXEC ，先用Multi找出该麦位上是否有这个用户，然后再下麦。
//		pipeliner := redisCli.GetRedis().TxPipeline()
//		redisUserId, err := pipeliner.HGet(context.Background(), redis.GetPrefixGroupMicGroupUuid(micUser.GroupUuid), strconv.Itoa(micUser.I)).Result()
//		if err != nil {
//			//已经不存在，则抛出错误
//			if err == redis2.Nil {
//				return nil
//			} else{
//				return myerr.WrapErr(err)
//			}
//		}
//		//不等于自己
//		if redisUserId != strconv.Itoa(int(micUser.operateUser)) {
//			return
//		}
//		redisCli.GetRedis().pipe := client.TxPipeline()
//	} else {
//		//上卖 同 禁言操作，注意
//		//上麦 HsetNx
//		//禁言 Multi EXEC ，先用Multi找出该麦位上是否有这个用户，然后再修改状态。。
//		redisCli.GetRedis().HSetNX(context.Background(), redis.GetPrefixGroupMicGroupUuid(micUser.GroupUuid), strconv.Itoa(micUser.I))
//	}
//}

//func (mic *Mic) Persistent() error {
//	b, err := json.Marshal(mic)
//	if err != nil {
//		return myerr.WrapErr(err)
//	}
//	_, err = redisCli.GetRedis().HSet(context.Background(), redis.GetPrefixGroupMicGroupUuid(mic.GroupUuid), strconv.Itoa(mic.I), b).Result()
//	if err != nil {
//		return myerr.WrapErr(err)
//	}
//
//	return nil
//}
