package noble_m

import (
	"gorm.io/gorm"
	"time"
)

const RENEWAL_LIMIT_DAY = 7

type ResNoble struct {
	Level         uint16
	PurchasePrice uint32
	RenewalPrice  uint32
	Duration      uint16
	PicUrl        string
	DailyGold     uint
	RideId        uint64 // 赠送的座驾ID
	HeaddressId   uint64 // 赠送的头饰ID
}

func GetAllConfig(db *gorm.DB) ([]ResNoble, error) {
	rows := make([]ResNoble, 0)
	err := db.Find(&rows).Error
	if err != nil {
		return nil, err
	}
	return rows, nil
}

func GetAllConfigMap(db *gorm.DB) (map[uint16]ResNoble, error) {
	rows, err := GetAllConfig(db)
	if err != nil {
		return nil, err
	}
	result := make(map[uint16]ResNoble, 0)
	for _, i := range rows {
		result[i.Level] = i
	}
	return result, nil
}

func GetConfigByLevel(db *gorm.DB, level uint16) (ResNoble, error) {
	r := ResNoble{}
	if err := db.Model(&ResNoble{}).First(&r, level).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return r, nil
		} else {
			return r, err
		}
	}
	return r, nil
}

// 根据过期时间推算价格
func CalcPrice(cfg ResNoble, endTime time.Time) uint32 {
	now := time.Now()
	price := cfg.RenewalPrice
	if now.After(endTime.AddDate(0, 0, RENEWAL_LIMIT_DAY)) {
		price = cfg.PurchasePrice
	}
	return price
}
