package res_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/res_e"
	"hilo-group/myerr"
)

type ResMultiText struct {
	mysql.Entity
	MsgId    uint
	Language mysql.Str
	Content  mysql.Str
}

func (r *ResMultiText) Get(db *gorm.DB) error {
	return db.Where(r).First(r).Error
}

func GetResMultiTextBy(db *gorm.DB, msgId uint, Language mysql.Str) (*ResMultiText, error) {
	r := ResMultiText{}
	if err := db.Where(&ResMultiText{
		MsgId:    msgId,
		Language: Language,
	}).First(&r).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			if err := db.Where(&ResMultiText{
				MsgId:    msgId,
				Language: res_e.DEFAULT_LANG,
			}).First(&r).Error; err != nil {
				return nil, myerr.WrapErr(err)
			}
		} else {
			return nil, myerr.WrapErr(err)
		}

	}
	return &r, nil
}
