package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/match_e"
	"hilo-group/myerr"
)

/**
 * 用户魅力分数
 **/
type MatchCharmUserScore struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	Score         mysql.Num
	Grade         mysql.Num
}

//获取魅力等级
func GetCharmGrade(model *domain.Model, userId mysql.ID) (uint32, uint32, error) {
	var charmUserScore MatchCharmUserScore
	if err := model.Db.Model(&MatchCharmUserScore{}).Where(&MatchCharmUserScore{
		UserId: userId,
	}).First(&charmUserScore).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return 0, 0, nil
		} else {
			return 0, 0, myerr.WrapErr(err)
		}
	}
	return charmUserScore.Grade, charmUserScore.Score, nil
}

type MatchCharmUserScoreDetail struct {
	mysql.Entity
	MatchCharmUserScoreId mysql.ID
	UserId                mysql.ID
	BeforeScore           mysql.Num
	Score                 mysql.Num
	AfterScore            mysql.Num
	Type                  match_e.MatchCharmUserScoreDetailType
	OrginId               mysql.ID
}

func addMatchCharmUserScoreDetail(model *domain.Model, matchCharmUserScoreId mysql.ID, userId mysql.ID, beforeScore mysql.Num, score mysql.Num, t match_e.MatchCharmUserScoreDetailType, orginId mysql.ID) error {
	if err := model.Db.Save(&MatchCharmUserScoreDetail{
		MatchCharmUserScoreId: matchCharmUserScoreId,
		UserId:                userId,
		BeforeScore:           beforeScore,
		Score:                 score,
		AfterScore:            beforeScore + score,
		Type:                  t,
		OrginId:               orginId,
	}).Error; err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

/**
 * 获取的分数同等级关系
 **/
type MatchCharmSetScoreGrade struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	MinNum        mysql.Num
	MaxNum        mysql.Num
	Grade         mysql.Num
}

func getMatchCharmUserScore(model *domain.Model, userId mysql.ID) (*MatchCharmUserScore, error) {
	var matchCharmUserScore MatchCharmUserScore
	if err := model.Db.Where(&MatchCharmUserScore{
		UserId: userId,
	}).First(&matchCharmUserScore).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			matchCharmUserScore = MatchCharmUserScore{
				UserId: userId,
				Score:  0,
				Grade:  0,
			}
		} else {
			return nil, err
		}
	}
	matchCharmUserScore.Model = model
	return &matchCharmUserScore, nil
}

/**
 * 增加分数
 **/
func (matchCharmUserScore *MatchCharmUserScore) updateScore(diamondNum mysql.Num) error {
	//接受高并发容错
	matchCharmUserScore.Score = diamondNum
	//对应其等级
	var matchCharmSetScoreGrade MatchCharmSetScoreGrade
	if err := matchCharmUserScore.Db.Where("min_num <= ? AND max_num >= ?", matchCharmUserScore.Score, matchCharmUserScore.Score).First(&matchCharmSetScoreGrade).Error; err != nil {
		return myerr.WrapErr(err)
	}
	matchCharmUserScore.Grade = matchCharmSetScoreGrade.Grade
	return nil
}
