package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"time"
)

type UserBindInfo struct {
	UserId       uint64    `json:"user_id"`
	Phone        string    `json:"phone"`
	PhoneCountry string    `json:"phone_country"`
	Pwd          string    `json:"pwd"`
	AreaCode     string    `json:"area_code"`
	Icon         string    `json:"icon"`
	CreateAt     time.Time `json:"create_at"`
	UpdateAt     time.Time `json:"update_at"`
}

func (p *UserBindInfo) TableName() string {
	return "user_bind_info"
}

type UserPhoneInfo struct {
	Phone        string `json:"phone"`
	PhoneCountry string `json:"phoneCountry"`
	AreaCode     string `json:"areaCode"`
	Icon         string `json:"icon"`
}

func GetUserBindInfoByUserId(model *domain.Model, userId uint64) (*UserBindInfo, error) {
	res := new(UserBindInfo)
	err := mysql.Db.Where(&UserBindInfo{UserId: userId}).First(&res).Error
	if err != nil {
		return nil, err
	}
	return res, nil
}
