package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/myerr"
	"strings"
)

type SuperManager struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	IsAll         bool
	Countries     string
}

func IsSuperManager(model *domain.Model, userId mysql.ID) (bool, error) {
	var n int64
	if err := model.Db.Model(&SuperManager{}).Where(&SuperManager{
		UserId: userId,
	}).Count(&n).Error; err != nil {
		return false, myerr.WrapErr(err)
	}
	return n > 0, nil
}

// 对某人是否有超管权限
func IsSuperManagerV2(model *domain.Model, userId, targetUserId mysql.ID) (bool, error) {
	var man SuperManager
	if err := model.Db.Model(&SuperManager{}).Where(&SuperManager{
		UserId: userId,
	}).First(&man).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			model.Log.Errorf("IsSuperManagerV2 fail:%v", err)
		}
		return false, nil
	}
	if man.IsAll {
		return true, nil
	}
	targetUser, err := GetUser(model, targetUserId)
	if err != nil {
		return false, err
	}
	countries := strings.Split(man.Countries, ",")
	for _, c := range countries {
		if c == targetUser.Country {
			return true, nil
		}
	}
	return false, nil
}

func GetSuperManagerAll(model *domain.Model) ([]uint64, error) {
	superManagers := []SuperManager{}
	if err := model.Db.Model(&SuperManager{}).Find(&superManagers).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	userIds := make([]uint64, 0, len(superManagers))
	for i, _ := range superManagers {
		userIds = append(userIds, superManagers[i].UserId)
	}
	return userIds, nil
}

func GetSuperManagerMap(userIds []uint64) (map[uint64]bool, error) {
	if len(userIds) == 0 {
		return map[uint64]bool{}, nil
	}
	var superManagers []SuperManager
	if err := mysql.Db.Model(&SuperManager{}).Where("user_id in (?)", userIds).Find(&superManagers).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	//转换成map
	rs := map[uint64]bool{}
	for i, _ := range userIds {
		rs[userIds[i]] = false
	}
	for i, _ := range superManagers {
		rs[superManagers[i].UserId] = true
	}
	return rs, nil
}
