package game_c

import (
	"context"
	"encoding/json"
	"git.hilo.cn/hilo-common/resource/redisCli"
	"hilo-group/_const/enum/game_e"
	"time"
)

type gameAutoJoinMsg struct {
	TraceId    string
	Token      string
	EnterType  string
	GameCode   string
	Is1V1      string
	GameMode   string
	Is1V1Robot string
}

func SetAutoMathEnterRoom(userId uint64, imGroupId, traceId, token, enterType, gameCode, is1V1, gameMode, is1V1Robot string) error {
	key := game_e.GetAutoMathEnterRoom(userId, imGroupId)
	info := gameAutoJoinMsg{traceId, token, enterType, gameCode, is1V1, gameMode, is1V1Robot}
	data, err := json.Marshal(info)
	if err != nil {
		return err
	}
	err = redisCli.GetRedis().LPush(context.Background(), key, data).Err()
	if err != nil {
		return err
	}
	redisCli.GetRedis().Expire(context.Background(), key, time.Second*10)
	return nil
}

func IsAutoMathEnterRoom(userId uint64, imGroupId string) (bool, string, string, string, string) {
	key := game_e.GetAutoMathEnterRoom(userId, imGroupId)
	data, err := redisCli.GetRedis().RPop(context.Background(), key).Bytes()
	if err != nil {
		return false, "", "", "", ""
	}
	info := gameAutoJoinMsg{}
	err = json.Unmarshal(data, &info)
	if err != nil {
		return false, "", "", "", ""
	}
	if info.Token != "" && info.TraceId != "" && info.EnterType != "" && info.GameCode != "" {
		redisCli.GetRedis().Del(context.Background(), key)
		return true, info.TraceId, info.Token, info.EnterType, info.GameCode
	}
	return false, "", "", "", ""
}
