package group_power_s

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/utils"
	"hilo-group/_const/enum/groupPower_e"
	"hilo-group/cv/group_power_cv"
	"hilo-group/domain/event/group_power_ev"
	"hilo-group/domain/model/groupPower_m"
	"hilo-group/domain/model/msg_m"
	"hilo-group/domain/model/noble_m"
	"hilo-group/domain/model/user_m"
)

type GroupPowerService struct {
	svc *domain.Service
}

func NewGroupPowerService(myContext *mycontext.MyContext) *GroupPowerService {
	svc := domain.CreateService(myContext)
	return &GroupPowerService{svc}
}

//用户加入国家势力
func (s *GroupPowerService) GroupPowerUserJoin(groupPowerId mysql.ID, userId mysql.ID) error {
	return s.svc.Transactional(func() error {
		model := domain.CreateModel(s.svc.CtxAndDb)
		groupPower, err := groupPower_m.GetGroupPower(model, groupPowerId)
		if err != nil {
			return err
		}
		groupPowerUser, err := groupPower.UserJoin(userId)
		if err != nil {
			return err
		}
		if err := groupPowerUser.Persistent(); err != nil {
			return err
		}
		return group_power_ev.PublishGroupPowerJoin(model, &group_power_ev.GroupPowerJoinEvent{
			UserId:       userId,
			GroupPowerId: groupPowerId,
		})
	})
}

//用户退出国家势力
func (s *GroupPowerService) GroupPowerUserLeave(groupPowerId mysql.ID, userId mysql.ID) (int, error) {
	remainSeconds := 0
	err := s.svc.Transactional(func() error {
		model := domain.CreateModel(s.svc.CtxAndDb)
		groupPower, err := groupPower_m.GetGroupPower(model, groupPowerId)
		if err != nil {
			return err
		}
		groupPowerUser, timeDiff, err := groupPower.UserLeave(userId)
		if err != nil {
			if timeDiff > 0 {
				remainSeconds = int(timeDiff.Seconds())
				return err
			}
			return err
		}
		if err := groupPowerUser.Persistent(); err != nil {
			return err
		}
		return group_power_ev.PublishGroupPowerLeave(model, &group_power_ev.GroupPowerLeaveEvent{
			UserId:       userId,
			GroupPowerId: groupPowerId,
		})
	})
	return remainSeconds, err
}

func GetGroupPowerMaxMemberNum(model *domain.Model, familyId uint64, groupPowerGrade groupPower_e.GroupPowerGrade) (maxNum int) {
	maxNum = group_power_cv.GroupPowerGradePrivilegeNum[groupPowerGrade][0].Num
	ownerId, err := groupPower_m.GetPowerOwner(model.Db, familyId)
	if err == nil {
		//检查是否是贵族
		if flag, err := noble_m.CheckNobleLevel(model.Db, ownerId, 6); err != nil {
		} else if flag {
			newNumMap := map[groupPower_e.GroupPowerGrade]int{
				groupPower_e.GroupPowerGrade0: 400,
				groupPower_e.GroupPowerGrade1: 600,
				groupPower_e.GroupPowerGrade2: 1000,
				groupPower_e.GroupPowerGrade3: 1400}
			if newNum, ok := newNumMap[groupPowerGrade]; ok {
				maxNum = newNum
			}
		}
	}
	users, err := groupPower_m.GetGroupPowerUser(model, familyId)
	if err != nil {
		return
	}
	memberNum := len(users)
	if memberNum > maxNum {
		maxNum = memberNum
	}
	return
}

// 检查需不需要通知用户拉取家族小助手消息
func CheckoutSendMsgToMgr(myContext *mycontext.MyContext, groupPowerId uint64) {
	defer utils.CheckGoPanic()
	model := domain.CreateModelContext(myContext)
	//// 申请人数
	//cnt, err := groupPower_m.CountGroupPowerApply(model, groupPowerId, 0)
	//if err != nil {
	//	model.Log.Errorf("CheckoutSendMsgToMgr err:%v, id:%v", err, groupPowerId)
	//	return
	//}
	//if cnt <= 0 {
	//	return
	//}
	// 找到家族管理员们
	mgrList, err := groupPower_m.GetGroupPowerMgrList(model, groupPowerId)
	if err != nil {
		model.Log.Errorf("CheckoutSendMsgToMgr err:%v, id:%v", err, groupPowerId)
		return
	}
	userMap, err := user_m.GetUserMapByIds(model, mgrList)
	if err != nil {
		model.Log.Errorf("CheckoutSendMsgToMgr err:%v, id:%v", err, groupPowerId)
		return
	}
	for _, v := range mgrList {
		if user, ok := userMap[v]; ok {
			msg_m.SendEmasMsgAssistant(model, user.ExternalId, user.DeviceType)
		}
	}
}
