package group_power_ev

import (
	"git.hilo.cn/hilo-common/domain"
)

//注册监听
var groupPowerExpireNoticeListen = new(domain.EventBase)

type GroupPowerExpireNoticeEvent struct {
}

//添加领域事件，在每个领域模型中init中添加，因为这是静态业务，非动态的。
func AddGroupPowerExpireNoticeSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(groupPowerExpireNoticeListen, callback)
}

//加入到异步操作中
func AddGroupPowerExpireNoticeAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(groupPowerExpireNoticeListen, callback)
}

//领域事件发布
func PublishGroupPowerExpireNotice(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(groupPowerExpireNoticeListen, model, event)
}
