package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/config"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/myerr"
	"time"
)

type MatchSetActityDailyType mysql.Type

const (
	//视频通话
	video MatchSetActityDailyType = 1
	//点击喜欢
	clickLike MatchSetActityDailyType = 2
	//点击消息
	clickMsg MatchSetActityDailyType = 3
	//匹配通过达到某个时间值
	matchConfirmTimeDailyType = 4
	//群组消息
	groupMsgDailyType = 5
	//上麦
	inMic = 6
)

/**
 * 每日的活跃分数设置
 **/
type MatchActitySetDaily struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	Type          MatchSetActityDailyType
	Score         mysql.Num
	MaxScore      mysql.Num
}

/**
 * 用户活跃分数
 **/
type MatchActityUserScore struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	Score         mysql.Num
	Grade         mysql.Num

	matchActityUserScoreDaily *MatchActityUserScoreDaily `gorm:"-"`
}

/**
 * 用户活跃分数，每日
 **/
type MatchActityUserScoreDaily struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	Score         mysql.Num
	Type          MatchSetActityDailyType
	Daily         mysql.Str
}

/**
 * 获取的分数同等级关系
 **/
type MatchActitySetScoreGrade struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	MinNum        mysql.Num
	MaxNum        mysql.Num
	Grade         mysql.Num
}

//获取活跃等级
func GetActityGrade(model *domain.Model, userId mysql.ID) (uint32, uint32, error) {
	var actityUserScore MatchActityUserScore
	if err := model.Db.Model(&MatchActityUserScore{}).Where(&MatchActityUserScore{UserId: userId}).First(&actityUserScore).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return 0, 0, nil
		} else {
			return 0, 0, myerr.WrapErr(err)
		}
	}
	return actityUserScore.Grade, actityUserScore.Score, nil
}

func getMatchActityUserScore(model *domain.Model, userId mysql.ID) (*MatchActityUserScore, error) {
	var matchActityUserScore MatchActityUserScore
	if err := model.Db.Where(&MatchActityUserScore{
		UserId: userId,
	}).First(&matchActityUserScore).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			matchActityUserScore = MatchActityUserScore{
				UserId: userId,
				Score:  0,
				Grade:  0,
			}
		} else {
			return nil, err
		}
	}
	matchActityUserScore.Model = model
	return &matchActityUserScore, nil
}

/**
 * 检查每日的某个类别的分数,
 * return false: 分数未满，true：分数已满了.
 **/
func (matchActityUserScore *MatchActityUserScore) checkDailyTypeScore(t MatchSetActityDailyType, daily mysql.Str) (bool, *MatchActityUserScoreDaily, mysql.Num, error) {
	var matchActitySetDaily MatchActitySetDaily
	if err := matchActityUserScore.Db.Where(&MatchActitySetDaily{
		Type: t,
	}).First(&matchActitySetDaily).Error; err != nil {
		return false, nil, 0, myerr.WrapErr(err)
	}
	//
	var matchActityUserScoreDaily MatchActityUserScoreDaily
	if err := matchActityUserScore.Db.Where(&MatchActityUserScoreDaily{
		UserId: matchActityUserScore.UserId,
		Type:   t,
		Daily:  daily,
	}).First(&matchActityUserScoreDaily).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return false, &MatchActityUserScoreDaily{
				UserId: matchActityUserScore.UserId,
				Score:  0,
				Type:   t,
				Daily:  daily,
			}, matchActitySetDaily.Score, nil
		} else {
			return false, nil, matchActitySetDaily.Score, nil
		}
	}
	//
	if matchActitySetDaily.MaxScore >= matchActityUserScoreDaily.Score {
		if matchActitySetDaily.MaxScore > (matchActityUserScoreDaily.Score + matchActitySetDaily.Score) {
			return false, &matchActityUserScoreDaily, matchActitySetDaily.Score, nil
		} else {
			return false, &matchActityUserScoreDaily, matchActitySetDaily.MaxScore - matchActityUserScoreDaily.Score, nil
		}

	} else {
		return true, &matchActityUserScoreDaily, matchActitySetDaily.Score, nil
	}
}

//获取当前的时间字符串
func getDailyStr() string {
	return time.Now().Format("2006-01-02")
}

/**
 * 增加分数
 **/
func (matchActityUserScore *MatchActityUserScore) addScore(t MatchSetActityDailyType) error {
	dailyStr := mysql.Str(getDailyStr())
	flag, matchActityUserScoreDaily, addScore, err := matchActityUserScore.checkDailyTypeScore(t, dailyStr)
	if err != nil {
		return err
	}
	//增加分数
	if flag == false {
		//检查vip
		//检查VIP，是否要*1.5倍
		user, err := GetUser(matchActityUserScore.Model, matchActityUserScore.UserId)
		if err != nil {
			return err
		}
		isVip, err := user.CheckVip()
		if err != nil {
			return err
		}
		//
		if isVip {
			addScore = addScore * mysql.Num(config.GetGradeConfig().ACTITY_SPEED_VIP) / 10
		}
		//接受高并发容错
		matchActityUserScoreDaily.Score = matchActityUserScoreDaily.Score + addScore
		//对应分数
		matchActityUserScore.Score = matchActityUserScore.Score + addScore
		//对应其等级
		var matchActitySetScoreGrade MatchActitySetScoreGrade
		if err := matchActityUserScore.Db.Where("min_num <= ? AND max_num >= ?", matchActityUserScore.Score, matchActityUserScore.Score).First(&matchActitySetScoreGrade).Error; err != nil {
			return myerr.WrapErr(err)
		}
		matchActityUserScore.Grade = matchActitySetScoreGrade.Grade

		matchActityUserScore.matchActityUserScoreDaily = matchActityUserScoreDaily
		return nil
	} else {
		matchActityUserScore.IsLazyLoad()
		return nil
	}
}
