package luckyWheel_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
)

type LuckyWheelSeat struct {
	mysql.Entity
	WheelId uint64
	GroupId string
	SeatId  uint
	UserId  uint64
	SeqId   uint
}

func (lws *LuckyWheelSeat) Create(db *gorm.DB) error {
	return db.Create(lws).Error
}

func (lws *LuckyWheelSeat) Get(db *gorm.DB) ([]LuckyWheelSeat, error) {
	result := make([]LuckyWheelSeat, 0)
	if err := db.Where(lws).Find(&result).Error; err != nil {
		return nil, err
	}
	return result, nil
}

func (lws *LuckyWheelSeat) SetSeqId(db *gorm.DB, seqId int) error {
	return db.Model(LuckyWheelSeat{}).Where(lws).Update("seq_id", seqId).Error
}
