package mgr_m

import (
	"database/sql/driver"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/myerr"
	"strings"
	"time"
)

type Strs []string

func (this *Strs) Scan(val interface{}) error {
	s := val.([]uint8)
	ss := strings.Split(string(s), ",")
	*this = ss
	return nil
}

func (this Strs) Value() (driver.Value, error) {
	str := strings.Join(this, ",")
	return str, nil
}

//群组Banner
type GroupBanner struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	Title         mysql.Str
	Image         mysql.Str
	Url           mysql.Str
	GroupCode     mysql.Str //群组code
	N             mysql.Num
	Status        mysql.UserYesNo
	Area          int   // 上线区域:0全区;1阿语区;2非阿语区;3指定国家
	CountryList   Strs  // 指定区域的国家列表
	StartAt       int64 // 上架时间戳
	EndAt         int64 // 下架时间戳
}

func GetGroupBanner(model *domain.Model, id mysql.ID) (*GroupBanner, error) {
	groupBanner := GroupBanner{}
	if err := model.Db.Model(&GroupBanner{}).First(&groupBanner, id).Error; err != nil {
		return &groupBanner, myerr.WrapErr(err)
	}
	groupBanner.Model = model
	return &groupBanner, nil
}

//加入
func AddGroupBanner(model *domain.Model, title mysql.Str, image mysql.Str, url mysql.Str, groupCode mysql.Str, n mysql.Num) *GroupBanner {
	return &GroupBanner{
		Model:     model,
		Title:     title,
		Image:     image,
		Url:       url,
		GroupCode: groupCode,
		N:         n,
		Status:    mysql.USER,
	}
}

//更新
func (groupBanner *GroupBanner) Update(title mysql.Str, image mysql.Str, url mysql.Str, groupCode mysql.Str, n mysql.Num) *GroupBanner {
	groupBanner.Title = title
	groupBanner.Image = image
	groupBanner.Url = url
	groupBanner.GroupCode = groupCode
	groupBanner.N = n
	return groupBanner
}

//上架
func (groupBanner *GroupBanner) User() *GroupBanner {
	groupBanner.Status = mysql.USER
	return groupBanner
}

//下架
func (groupBanner *GroupBanner) NoUser() *GroupBanner {
	groupBanner.Status = mysql.NOUSER
	return groupBanner
}

// 房间Banner
type RoomBanner struct {
	mysql.Entity
	Title       mysql.Str
	Image       mysql.Str
	Url         mysql.Str
	N           mysql.Num
	Status      mysql.UserYesNo
	Area        int  // 上线区域:0全区;1阿语区;2非阿语区;3指定国家
	CountryList Strs // 指定区域的国家列表
}

func (rb *RoomBanner) GetRoomBanners(db *gorm.DB, vcAllow bool) ([]RoomBanner, error) {
	rows := make([]RoomBanner, 0)
	if err := db.Model(&RoomBanner{}).Where(rb).Order("n DESC").Find(&rows).Error; err != nil {
		return nil, err
	}
	res := make([]RoomBanner, 0, len(rows))
	for _, v := range rows {
		// 版本控制
		if !vcAllow && (v.ID == 241 || v.ID == 781 || v.ID == 771 || v.ID == 911 || v.ID == 841 || v.ID == 851 || v.ID == 1001 || v.ID == 981) {
			continue
		}
		res = append(res, v)
	}
	return res, nil
}

func (rb *RoomBanner) Create(db *gorm.DB) error {
	return db.Save(rb).Error
}

func (rb *RoomBanner) Save(db *gorm.DB) error {
	return db.Omit("status").Save(rb).Error
}

func (rb *RoomBanner) SetStatus(db *gorm.DB, status uint8) error {
	return db.Model(&RoomBanner{}).Where(rb).Update("status", status).Error
}

type DiscoveryBanner struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	Title         mysql.Str
	Image         mysql.Str
	Url           mysql.Str
	GroupCode     mysql.Str
	N             mysql.Num
	BeginTime     time.Time
	EndTime       time.Time
	Area          int  // 上线区域:0全区;1阿语区;2非阿语区;3指定国家
	CountryList   Strs // 指定区域的国家列表
}

func GetDiscoveryBannerOrErr(model *domain.Model, id mysql.ID) (*DiscoveryBanner, error) {
	discoveryBanner := DiscoveryBanner{}
	if err := model.Db.Model(&DiscoveryBanner{}).First(&discoveryBanner, id).Error; err != nil {
		return &discoveryBanner, myerr.WrapErr(err)
	}
	discoveryBanner.Model = model
	return &discoveryBanner, nil
}

func InitDiscoveryBanner(model *domain.Model, title mysql.Str, image mysql.Str, url mysql.Str, groupCode mysql.Str, n mysql.Num, beginTime time.Time, endTime time.Time) *DiscoveryBanner {
	return &DiscoveryBanner{
		Model:     model,
		Title:     title,
		Image:     image,
		Url:       url,
		GroupCode: groupCode,
		N:         n,
		BeginTime: beginTime,
		EndTime:   endTime,
	}
}

//更新
func (discoveryBanner *DiscoveryBanner) Update(title mysql.Str, image mysql.Str, url mysql.Str, groupCode mysql.Str, n mysql.Num, beginTime time.Time, endTime time.Time) *DiscoveryBanner {
	discoveryBanner.Title = title
	discoveryBanner.Image = image
	discoveryBanner.Url = url
	discoveryBanner.GroupCode = groupCode
	discoveryBanner.N = n
	discoveryBanner.BeginTime = beginTime
	discoveryBanner.EndTime = endTime
	return discoveryBanner
}

func (discoveryBanner *DiscoveryBanner) EditEndTime(time time.Time) *DiscoveryBanner {
	discoveryBanner.EndTime = time
	return discoveryBanner
}

func (discoveryBanner *DiscoveryBanner) EditBeginTime(time time.Time) *DiscoveryBanner {
	discoveryBanner.BeginTime = time
	return discoveryBanner
}
