package group_s

import (
	"git.hilo.cn/hilo-common/domain"
	"hilo-group/_const/enum/msg_e"
	"hilo-group/domain/model/group_m"
	"hilo-group/domain/model/res_m"
)

func (s *GroupService) GetWelcomeText(groupInfo *group_m.GroupInfo) (string, uint64, bool, error) {
	model := domain.CreateModelContext(s.svc.MyContext)

	g := group_m.GroupWelcomeText{GroupId: groupInfo.ImGroupId}
	gwt, err := g.Get(model.Db)
	if err != nil {
		return "", 0, false, err
	}

	if gwt == nil {
		// 通过国家推断语言
		lang, err := res_m.GetLangeByCountry(model.Db, groupInfo.Country)
		if err != nil {
			return "", 0, false, err
		}

		resMul, err := res_m.GetResMultiTextBy(model.Db, msg_e.MSG_ID_GROUP_WELCOME, lang)
		if err != nil {
			return "", 0, false, err
		}
		return resMul.Content, groupInfo.Owner, true, nil
	} else {
		return gwt.Text, gwt.UserId, false, nil
	}
}
