package rocket_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
)

type RocketAwardConfig struct {
	mysql.Entity
	Stage       uint16
	Seq         uint16
	AwardType   uint16
	AwardId     uint64
	Num         uint32
	Duration    uint32
	Probability uint16
}

// fixme:处理重复ID
func (rac *RocketAwardConfig) GetAll(db *gorm.DB) (map[uint16][]RocketAwardConfig, error) {
	rows := make([]RocketAwardConfig, 0)
	if err := db.Where(rac).Order("Seq").Find(&rows).Error; err != nil {
		return nil, err
	}
	result := make(map[uint16][]RocketAwardConfig, 0)
	for _, i := range rows {
		if _, ok := result[i.Stage]; !ok {
			result[i.Stage] = make([]RocketAwardConfig, 0)
		}
		result[i.Stage] = append(result[i.Stage], i)
	}
	return result, nil
}

// fixme:处理重复ID
func GetAwardConfigByStage(db *gorm.DB, stage uint16) ([]RocketAwardConfig, error) {
	rows := make([]RocketAwardConfig, 0)
	if err := db.Model(&RocketAwardConfig{}).Where("stage = ?", stage).Order("Seq").Find(&rows).Error; err != nil {
		return nil, err
	}
	return rows, nil
}

type RocketAward struct {
	mysql.Entity
	ResultId   uint64
	UserId     uint64
	Rank       uint16
	AwardCfgId uint64
	Diamond    uint32
}

func (ra *RocketAward) Create(db *gorm.DB) error {
	return db.Create(ra).Error
}

func (ra *RocketAward) BatchGetRank(db *gorm.DB, ids []uint64) (map[uint64]uint64, error) {
	result := make(map[uint64]uint64, 0)
	// ids为空就不用查了
	if len(ids) <= 0 {
		return result, nil
	}
	rows := make([]RocketAward, 0)
	if err := db.Where(ra).Where("result_id IN ?", ids).Find(&rows).Error; err != nil {
		return nil, err
	}
	for _, i := range rows {
		result[i.ResultId] = i.UserId
	}
	return result, nil
}

func (ra *RocketAward) BatchGetAward(db *gorm.DB, ids []uint64) (map[uint64]RocketAward, error) {
	result := make(map[uint64]RocketAward, 0)
	if len(ids) <= 0 { // 优化ids空的时候就别查库了
		return result, nil
	}
	rows := make([]RocketAward, 0)
	if err := db.Where(ra).Where("result_id IN ?", ids).Find(&rows).Error; err != nil {
		return nil, err
	}
	for _, i := range rows {
		result[i.ResultId] = i
	}
	return result, nil
}

func (ra *RocketAward) GetTopRank(db *gorm.DB, rank uint16) (map[uint64]uint16, error) {
	rows := make([]RocketAward, 0)
	if err := db.Where(ra).Where("`rank` > 0 AND `rank` <= ?", rank).Find(&rows).Error; err != nil {
		return nil, err
	}
	result := make(map[uint64]uint16, 0)
	for _, i := range rows {
		result[i.UserId] = i.Rank
	}
	return result, nil
}

func (ra *RocketAward) GetDiamondTotal(db *gorm.DB) (uint32, error) {
	type rec struct {
		D uint32
	}
	row := rec{}
	if err := db.Model(&RocketAward{}).Select("SUM(diamond) AS d").Where(ra).Where("`rank` = ?", ra.Rank).First(&row).Error; err != nil {
		return 0, err
	}
	return row.D, nil
}

// 查询用户获取3级火箭第一名的次数
func GetUserTopCount(db *gorm.DB, userId uint64) (int64, error) {
	var count int64 = 0
	if err := db.Table("rocket_result rr ").Joins("INNER JOIN rocket_award ra on rr.id = ra.result_id").
		Where("stage = ? AND `rank` = ? AND user_id = ?", 2, 1, userId).
		Count(&count).Error; err != nil {
		return 0, err
	}
	return count, nil
}

type RocketGuestAward struct {
	Stage       uint16
	LowerBound  uint32
	UpperBound  uint32
	Total       uint32
	Probability uint16
}

func GetGuestAwardConfig(db *gorm.DB, stage uint16) ([]RocketGuestAward, error) {
	rows := make([]RocketGuestAward, 0)
	if err := db.Model(&RocketGuestAward{}).Where("stage = ?", stage).Find(&rows).Error; err != nil {
		return nil, err
	}
	return rows, nil
}

type RocketAwardEvent struct {
	//Stage       uint16
	//Seq         uint16
	RocketAwardId uint64
	UserId        uint64
	AwardType     uint16
	AwardId       uint64
	Num           uint32
	Duration      uint32
	//Probability uint16
}
