package count_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
)

type VideoChatTimeTotal struct {
	UserId       mysql.ID
	VideoSeconds mysql.Num
}

// 增加视频总时长
func AddVideoChatTimeTotal(model *domain.Model, userId mysql.ID, videoSeconds mysql.Num) error {
	var videoChatTimeTotal VideoChatTimeTotal
	if err := model.Db.WithContext(model).Where("user_id = ?", userId).First(&videoChatTimeTotal).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			model.Log.Errorf("AddVideoChatTimeTotal fail:%v", err)
			return err
		}
		// gorm.ErrRecordNotFound
		videoChatTimeTotal.UserId, videoChatTimeTotal.VideoSeconds = userId, videoSeconds
		if err = model.Db.WithContext(model).Create(&videoChatTimeTotal).Error; err != nil {
			model.Log.Errorf("AddVideoChatTimeTotal create fail,data:%v,err:%v", videoChatTimeTotal, err)
			// 高并发写,走下面的update
		} else {
			return nil
		}
	}
	// update video seconds
	if err := model.Db.WithContext(model).Model(VideoChatTimeTotal{}).Where("user_id = ?", userId).
		UpdateColumn("video_seconds", gorm.Expr("video_seconds + ?", videoSeconds)).Error; err != nil {
		model.Log.Errorf("AddVideoChatTimeTotal update fail:%v", err)
		return err
	}
	return nil
}

// 获取视频总时长
func GetVideoChatTimeTotal(model *domain.Model, userId mysql.ID) (mysql.Num, error) {
	var videoChatTimeTotal VideoChatTimeTotal
	if err := model.Db.WithContext(model).Model(VideoChatTimeTotal{}).Where("user_id = ?", userId).First(&videoChatTimeTotal).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			model.Log.Errorf("GetVideoChatTimeTotal fail:%v", err.Error())
			return 0, err
		}
	}
	return videoChatTimeTotal.VideoSeconds, nil
}