package common

import (
	"git.hilo.cn/hilo-common/resource/config"
	"strings"
)

// 去除slice中的重复元素
func UniqueSliceUInt64(sliceIn []uint64) []uint64 {
	sliceOut := make([]uint64, 0, len(sliceIn))
	m := make(map[uint64]struct{}, len(sliceIn))
	for _, i := range sliceIn {
		if _, ok := m[i]; !ok {
			m[i] = struct{}{}
			sliceOut = append(sliceOut, i)
		}
	}
	return sliceOut
}

// 补全url，区分处理oss和aws两种情况
func MakeFullUrl(url string) string {
	if strings.HasPrefix(url, config.GetConfigOss().OSS_CDN) || strings.HasPrefix(url, config.GetConfigAws().AWS_CDN) {
		return url
	} else if strings.HasPrefix(url, "nextvideo/") {
		return config.GetConfigOss().OSS_CDN + url
	} else if strings.HasPrefix(url, config.GetConfigAws().AWS_DIR) {
		return config.GetConfigAws().AWS_CDN + url
	} else {
		return url
	}
}

func PageNext(total int64, pageIndex, pageSize int) (int, bool) {
	var nextIdx int
	var hasNext bool
	if total >= int64(pageIndex+pageSize) {
		hasNext = true
		nextIdx = pageIndex + pageSize
	}
	return nextIdx, hasNext
}
