package groupPower_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/groupPower_e"
)

type GroupPowerExpRank struct {
	GroupPowerId mysql.ID
	Exp          mysql.Num
	Rank         int
}

// 获取家族经验排行榜
// param limit: 排行榜人数
// 10166 线上员工,对应的势力不上榜,groupPowerId=8951
func GetGroupPowerExpRank(model *domain.Model, beginDate, endDate string, limit int, gpStatus groupPower_e.GroupPowerStatus, area int) ([]GroupPowerExpRank, error) {
	var res []GroupPowerExpRank
	db := model.DB().Table("group_power_day_exp gpd").Select("gpd.group_power_id,SUM(gpd.exp) as exp").
		Where("gpd.group_power_id <> 8951").
		Where("gpd.date BETWEEN ? AND ?", beginDate, endDate)
	if gpStatus > 0 {
		db = db.Joins("left join group_power gp on gpd.group_power_id = gp.id").Where("gp.status = ?", gpStatus)
		if area > 0 {
			db = db.Joins("left join group_info gi on gp.group_uid = gi.im_group_id left join res_country rs on gi.country = rs.name").
				Where("rs.area = ?", area)
		}
	}
	if err := db.Group("gpd.group_power_id").Order("exp DESC").Limit(limit).Find(&res).Error; err != nil {
		model.Log.Errorf("GetGroupPowerExpRank fail:%v", err)
		return res, err
	}
	for i := range res {
		res[i].Rank = i + 1
	}
	return res, nil
}

// 获取我的家族经验排行榜
func GetMyGroupPowerExpRank(model *domain.Model, beginDate, endDate string, groupPowerId uint64) (GroupPowerExpRank, error) {
	var res GroupPowerExpRank
	if err := model.DB().Table("group_power_day_exp").Select("group_power_id,SUM(exp) as exp").
		Where("date BETWEEN ? AND ? AND group_power_id = ?", beginDate, endDate, groupPowerId).Group("group_power_id").First(&res).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			model.Log.Errorf("GetMyGroupPowerExpRank fail:%v", err)
			return res, err
		}
		return res, nil
	}
	return res, nil
}

// 获取我的家族月排名是多少，超过30则返回31
func GetGroupPowerExpRankById(model *domain.Model, beginDate, endDate string, limit int, groupPowerId uint64) (int, error) {
	var res []GroupPowerExpRank
	if err := model.DB().Table("group_power_day_exp").Select("group_power_id,SUM(exp) as exp").
		Where("date BETWEEN ? AND ?", beginDate, endDate).Group("group_power_id").Order("exp DESC").Limit(limit).Find(&res).Error; err != nil {
		model.Log.Errorf("GetMyGroupPowerExpRank fail:%v", err)
		return 0, err
	}
	for i := range res {
		res[i].Rank = i + 1
	}
	myRank := 31
	for _, v := range res {
		if v.GroupPowerId == groupPowerId {
			myRank = v.Rank
		}
	}
	return myRank, nil
}
