package group_m

import (
	"fmt"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/myerr"
	"time"
)

type GroupMicInLog struct {
	mysql.Entity
	UserId  mysql.ID
	GroupId mysql.Str
}

func (p *GroupMicInLog) TableName() string {
	month := time.Now().Format("200601")
	return fmt.Sprintf("group_mic_in_log_%s", month)
}

func AddGroupMicInLog(userId mysql.ID, groupId mysql.Str) error {
	if err := mysql.Db.Table((&GroupMicInLog{}).TableName()).Create(&GroupMicInLog{
		Entity:  mysql.Entity{},
		UserId:  userId,
		GroupId: groupId,
	}).Error; err != nil {
		mylogrus.MyLog.Errorf("GroupMicInLog save fail, err:%v", err)
		return myerr.WrapErr(err)
	}
	return nil
}
