package group_power_cv

import (
	"hilo-group/_const/enum/groupPower_e"
	"hilo-group/cv/user_cv"
)

// 家族信息
type CvGroupPowerInfo struct {
	CvGroupPowerBase   `json:",inline"`
	CvGroupPowerMember `json:",inline"`
	CvGroupPowerGrade  `json:",inline"`
}

// 家族基本信息
type CvGroupPowerBase struct {
	Id        uint64 `json:"id"`        // 家族id
	Icon      string `json:"icon"`      // 家族图片
	Name      string `json:"name"`      // 家族名
	Nameplate string `json:"nameplate"` // 铭牌
}

// 家族成员
type CvGroupPowerMember struct {
	MemberNum uint32 `json:"memberNum"` // 当前成员数
	MemberMax uint32 `json:"memberMax"` // 成员上限
}

// 家族等级
type CvGroupPowerGrade struct {
	Grade    groupPower_e.GroupPowerGrade `json:"grade"`              // 等级 0:青铜 1:白银 2:黄金 3:黑金
	Exp      uint32                       `json:"exp"`                // 经验值
	NextExp  uint32                       `json:"nextExp,omitempty"`  // 下个等级所需经验值
	ExpireAt string                       `json:"expireAt,omitempty"` // 有效期
}

// 家族榜单
type CvGroupPowerRank struct {
	MyGroupPower *CvGroupPowerRankData  `json:"myGroupPower,omitempty"` // 我的家族排名
	Items        []CvGroupPowerRankData `json:"items"`                  // 列表
}

// 家族月度排行活动榜单
type CvGroupPowerRankMontAct struct {
	MyGroupPower     *CvGroupPowerRankData  `json:"myGroupPower"`     // 我的家族排名
	Items            []CvGroupPowerRankData `json:"items"`            // 列表
	MyGroupPowerLast *CvGroupPowerRankData  `json:"myGroupPowerLast"` // 我的家族排名(上月)
	ItemsLast        []CvGroupPowerRankData `json:"itemsLast"`        // 列表(上月)
	LeftSecond       int64                  `json:"leftSecond"`       // 活动倒计时
}

type CvGroupPowerRankData struct {
	CvGroupPowerBase  `json:",inline"`
	CvGroupPowerGrade `json:",inline"`
	Rank              int                     `json:"rank"`     // 排名
	StarList          []*CvGroupPowerStarData `json:"starList"` // 家族贡献top10
}

// 家族之星
type CvGroupPowerStarData struct {
	User  user_cv.CvUserTiny `json:"user"`
	Score uint32             `json:"score"` // 对应分值
}

// 资源等级
type CvResGrade struct {
	Grade groupPower_e.GroupPowerGrade `json:"grade"` // 等级
}

// 特权信息
type CvPrivilege struct {
	Type groupPower_e.GroupPowerPrivilege `json:"type"` // 特权id 1:成员数 2:管理员数 3:家族铭牌 4:家族徽章装饰 5:编辑铭牌 6:家族头饰
	Num  int                              `json:"num"`  // 数目
	Icon string                           `json:"icon"` // 图标
}

// 家族等级页
type CvGroupPowerGradeDetail struct {
	GroupPowerBase  CvGroupPowerBase  `json:"groupPowerBase"`  // 家族基本信息
	GroupPowerGrade CvGroupPowerGrade `json:"groupPowerGrade"` // 家族等级信息
	ResGradeList    []CvResGrade      `json:"resGradeList"`    // 资源等级列表,青铜、白银、黄金、黑金
	PrivilegeList   []CvPrivilege     `json:"privilegeList"`   // 等级特权
	IsMember        bool              `json:"isMember"`        // 是否家族成员
}

var CvResGradeList = []CvResGrade{
	{groupPower_e.GroupPowerGrade0},
	{groupPower_e.GroupPowerGrade1},
	{groupPower_e.GroupPowerGrade2},
	{groupPower_e.GroupPowerGrade3},
}

var GroupPowerGradePrivilegeNum = map[groupPower_e.GroupPowerGrade][]CvPrivilege{
	groupPower_e.GroupPowerGrade0: {
		{groupPower_e.GroupPowerPrivilegeMemberNum, 300, "https://image.whoisamy.shop/hilo/resource/family/users.png"},
		{groupPower_e.GroupPowerPrivilegeMgrNum, 10, "https://image.whoisamy.shop/hilo/resource/family/gl_user.png"},
		{groupPower_e.GroupPowerPrivilegeNameplate, 1, "https://image.whoisamy.shop/hilo/resource/family/nameplate_black.png"},
		{groupPower_e.GroupPowerPrivilegeMedal, 1, "https://image.whoisamy.shop/hilo/resource/family/privilege_black.png"},
	},
	groupPower_e.GroupPowerGrade1: {
		{groupPower_e.GroupPowerPrivilegeMemberNum, 500, "https://image.whoisamy.shop/hilo/resource/family/users.png"},
		{groupPower_e.GroupPowerPrivilegeMgrNum, 15, "https://image.whoisamy.shop/hilo/resource/family/gl_user.png"},
		{groupPower_e.GroupPowerPrivilegeNameplate, 1, "https://image.whoisamy.shop/hilo/resource/family/nameplate_cyan.png"},
		{groupPower_e.GroupPowerPrivilegeMedal, 1, "https://image.whoisamy.shop/hilo/resource/family/privilege_cyan.png"},
		{groupPower_e.GroupPowerPrivilegeNameplateEdit, 1, "https://image.whoisamy.shop/hilo/resource/family/edit_cyan.png"},
	},
	groupPower_e.GroupPowerGrade2: {
		{groupPower_e.GroupPowerPrivilegeMemberNum, 800, "https://image.whoisamy.shop/hilo/resource/family/users.png"},
		{groupPower_e.GroupPowerPrivilegeMgrNum, 20, "https://image.whoisamy.shop/hilo/resource/family/gl_user.png"},
		{groupPower_e.GroupPowerPrivilegeNameplate, 1, "https://image.whoisamy.shop/hilo/resource/family/nameplate_white.png"},
		{groupPower_e.GroupPowerPrivilegeMedal, 1, "https://image.whoisamy.shop/hilo/resource/family/privilege_white.png"},
		{groupPower_e.GroupPowerPrivilegeNameplateEdit, 1, "https://image.whoisamy.shop/hilo/resource/family/edit_white.png"},
		{groupPower_e.GroupPowerPrivilegeNameplateHeadwear, 1, "https://image.whoisamy.shop/hilo/resource/family/headwear_white.png"},
	},
	groupPower_e.GroupPowerGrade3: {
		{groupPower_e.GroupPowerPrivilegeMemberNum, 1200, "https://image.whoisamy.shop/hilo/resource/family/users.png"},
		{groupPower_e.GroupPowerPrivilegeMgrNum, 25, "https://image.whoisamy.shop/hilo/resource/family/gl_user.png"},
		{groupPower_e.GroupPowerPrivilegeNameplate, 1, "https://image.whoisamy.shop/hilo/resource/family/nameplate_yellow.png"},
		{groupPower_e.GroupPowerPrivilegeMedal, 1, "https://image.whoisamy.shop/hilo/resource/family/privilege_yellow.png"},
		{groupPower_e.GroupPowerPrivilegeNameplateEdit, 1, "https://image.whoisamy.shop/hilo/resource/family/edit_yellow.png"},
		{groupPower_e.GroupPowerPrivilegeNameplateHeadwear, 1, "https://image.whoisamy.shop/hilo/resource/family/headwear_yellow.png"},
	},
}
