package common

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/utils"
	"github.com/bluele/gcache"
	"time"
)

// 改成lru
var userMedalMergeLru = gcache.New(10000).LRU().Build()

func GetUserMedalMergeCache(userId mysql.ID) ([]uint32, error) {
	if data, err := userMedalMergeLru.Get(userId); err == nil {
		return data.([]uint32), nil
	}
	return nil, nil
}

func SetUserMedalMergeCache(userId mysql.ID, data []uint32) {
	_ = userMedalMergeLru.SetWithExpire(userId, data, time.Minute*15)
}

// 删除勋章缓存, 延迟删除
func DelUserMedalMergeCacheDelay(userId mysql.ID) {
	go func() {
		defer utils.CheckGoPanic()
		time.Sleep(time.Second * 5)
		DelUserMedalMergeCache(userId)
	}()
}

func DelUserMedalMergeCache(userId mysql.ID) {
	userMedalMergeLru.Remove(userId)
}
