package rpc_m

import (
	"encoding/json"
	"fmt"
	"hilo-socketCenter/common/mylogrus"
	"hilo-socketCenter/common/mysql"
	"strconv"
	"time"
)

type TypeRpc uint8

const (
//MatchConfirm   TypeRpc = 101
//CallReady      TypeRpc = 102
//AddTimeGift    TypeRpc = 103
//AddTimeFree    TypeRpc = 104
//RecallWindow   TypeRpc = 109
//Video          TypeRpc = 110
//VideoCallReady TypeRpc = 111
)

type RpcLog struct {
	ID       uint64 `gorm:"primary_key"`
	Type     TypeRpc
	UserId   string
	Msg      string
	Err      string
	FailUids string
}

func (RpcLog) TableName() string {
	month := time.Now().Format("200601")
	return fmt.Sprintf("rpc_log_%s", month)
}

func AddRpcLog(t TypeRpc, userId uint64, msg string, failUids []uint64, err error) {
	errStr := ""
	if err != nil {
		errStr = err.Error()
	}
	failUidStr, _ := json.Marshal(failUids)
	logRpc := RpcLog{
		Type:     t,
		UserId:   strconv.FormatUint(userId, 10),
		Msg:      msg,
		Err:      errStr,
		FailUids: string(failUidStr[:]),
	}
	if e := mysql.Db.Table(RpcLog{}.TableName()).Create(&logRpc).Error; e != nil {
		mylogrus.MyLog.Errorf("log rpc save fail, err:%v", e)
	}
}

func AddRpcLogs(t TypeRpc, userIds []uint64, msg string, failUids []uint64, err error) {
	errStr := ""
	if err != nil {
		errStr = err.Error()
	}
	failUidStr, _ := json.Marshal(failUids)
	userIdStr, _ := json.Marshal(userIds)
	logRpc := RpcLog{
		Type:     t,
		UserId:   string(userIdStr[:]),
		Msg:      msg,
		Err:      errStr,
		FailUids: string(failUidStr[:]),
	}
	if e := mysql.Db.Table(RpcLog{}.TableName()).Create(&logRpc).Error; e != nil {
		mylogrus.MyLog.Errorf("log rpc save fail, err:%v", e)
	}
}
