package mysql

import (
	"strconv"
)

/**
基于PDM,建立统计的数据domain结构。注意，不要选择0， 因为go的int默认值为0
*/

//主键ID
type ID = uint64

//性别
type Sex = uint8

//加减
type AddReduce = uint8

//拥有
type YesNo = uint8

//短描述
type Str = string

//时间戳
type Time = int64

//状态
type UserYesNo = uint8

//平台
type Platform = uint8

//多枚举类型
type Type = uint8

//数量
type Num = uint32

//时间戳
type Timestamp = uint64

//排序
type Index = uint16

//数量，并且用到-1作为特殊标记位
type NumAll = int

//开启关闭
type OpenClose = uint8

//逻辑删除
type LogicDel = uint8

//设备
type Device = uint8

type PeriodType = uint8

type FinishYesNo = uint8

type PayOrderType = uint8

//性别
const (
	MAN   Sex = 1
	WOMAN Sex = 2
	EMPTY Sex = 0
)

//yes no
const (
	YES YesNo = 1
	NO  YesNo = 2
)

const (
	OPEN  OpenClose = 1
	CLOSE OpenClose = 2
)

//加，减
const (
	ADD          AddReduce = 1
	REDUCE       AddReduce = 2
	NilAddREDUCE AddReduce = 3
)

const (
	USER   UserYesNo = 1
	NOUSER UserYesNo = 2
)

const (
	Apple     Platform = 1
	GOOGLE    Platform = 2
	EGG_PLANT Platform = 3 // 通过starchat回调的茄子充值 代理充值
	Checkout  Platform = 4
	PayerMax  Platform = 5 // 通过hilo发起，starchat回调的PayerMax/茄子充值
	Paypal    Platform = 6 // paypal

	ApplePink  Platform = 31 // Apple pay 购买粉钻
	GOOGLEPink Platform = 32 // GOOGLE pay 购买粉钻

	PayTypeZero        PayOrderType = 0 //
	PayTypeProxy       PayOrderType = 1 // 1.代理给自己充值
	PayTypeUserToProxy PayOrderType = 2 // 2.用户给代理充值

	CheckoutName = "cheakout支付"
	PayerMaxName = "茄子支付"
	PayPalName   = "PayPal支付"
)

//逻辑删除
const (
	EXIST LogicDel = 1
	DEL   LogicDel = 2
)

const (
	DAY   PeriodType = 1
	Week  PeriodType = 2
	Month PeriodType = 3
	Year  PeriodType = 4
)

const (
	FinishNo  FinishYesNo = 0
	FinishYes FinishYesNo = 1
)

const (
	DiamondYellow Type = 1
	DiamondPink   Type = 2
)

func IdToStr(id ID) string {
	return strconv.Itoa(int(id))
}

func StrToId(id string) (ID, error) {
	var idInt int
	var err error
	if idInt, err = strconv.Atoi(id); err != nil {
		return 0, err
	}
	return ID(idInt), nil
}

func NumToString(num Num) string {
	return strconv.Itoa(int(num))
}

func TypeToString(t Type) string {
	return strconv.Itoa(int(t))
}

func StrToType(t string) (Type, error) {
	var tInt int
	var err error
	if tInt, err = strconv.Atoi(t); err != nil {
		return 0, err
	}
	return Type(tInt), nil
}

/*func IdToUint64(id ID) uint64 {
	return uint64(id)
}*/

func IdsToUint64(ids []ID) []uint64 {
	uints := []uint64{}
	for i := 0; i < len(ids); i++ {
		uints = append(uints, uint64(ids[i]))
	}
	return uints
}
