package redisCli

import (
	"context"
	"github.com/go-redis/redis/v8"
	"hilo-socketCenter/common/config"
	"hilo-socketCenter/common/mylogrus"
	"log"
)

var RedisCluster *redis.Client

func init() {
	RedisCluster = redis.NewClient(&redis.Options{
		Addr:         config.GetConfigRedis().REDIS_CLUSTER_HOST,
		Password:     config.GetConfigRedis().REDIS_CLUSTER_PASSWORD, // no password set
		DB:           0,                                              // use default DB
		PoolSize:     200,
		MinIdleConns: 20,
	})
	pong, err := RedisCluster.Ping(context.Background()).Result()
	if err != nil {
		mylogrus.MyLog.Warn(err)
		mylogrus.MyLog.Fatal("redis db0 connect fail")
	} else {
		log.Println("redis db0 connection success - " + pong)
	}
	// log hook
	//RedisClient.AddHook(redisHook{})
}

func GetRedisCluster() *redis.Client {
	return RedisCluster
}
