package common

import (
	"fmt"
	"net"
	"runtime/debug"

	"hilo-userProxy/common/mylogrus"
)

func CheckGoPanic() {
	if r := recover(); r != nil {
		//打印错误堆栈信息
		mylogrus.MyLog.Errorf("ACTION PANIC: %v, stack: %v", r, string(debug.Stack()))
	}
}

// 获取内网地址
func GetClientIpV2() (string, error) {
	addrs, err := net.InterfaceAddrs()

	if err != nil {
		return "", err
	}

	for _, address := range addrs {
		// 检查ip地址判断是否回环地址
		if ipNet, ok := address.(*net.IPNet); ok && ipNet.IP.IsGlobalUnicast() {
			//if ipNet, ok := address.(*net.IPNet); ok && !ipNet.IP.IsLoopback() {
			if ipNet.IP.To4() != nil {
				return ipNet.IP.String(), nil
			}

		}
	}
	return "", fmt.Errorf("can not find the client ip address")
}
