package dao

import (
	"gomicro-base/common/mysql"
	"gomicro-base/service/demo/internal/conf"
	"gomicro-base/service/demo/internal/model"
	"gorm.io/gorm"
)

// Dao 查询数据库
type Dao struct {
	DB *gorm.DB
}

func New(c *conf.Config) (d *Dao) {
	d = &Dao{
		DB: mysql.NewDB(c.Mysql),
	}
	return
}

// GetUserById 根据id查询用户
func (d *Dao) GetUserById(id int, column []string) (res *model.User, err error) {
	res = &model.User{}
	err = d.DB.Model(&model.User{}).
		Select(column).
		Where("id = ?", id).Take(res).Error
	return
}

// ListUserGtId 查询大于该id的用户列表
func (d *Dao) ListUserGtId(id int, limit int) (res []*model.User, err error) {
	res = make([]*model.User, 0)
	err = d.DB.Model(&model.User{}).
		Where("id > ?", id).
		Limit(limit).Order("id desc").
		Find(&res).Error
	return
}
