#!/bin/bash

os=$(uname -s)
project=$1
parent_dir=$(dirname $(cd $(dirname "$0") && pwd))

# 检查项目名, 目录是否存在
if [[ -z $project ]]; then
    echo '未指定项目名'
    exit 0
fi

api_dir="$parent_dir/api/$project"
service_dir="$parent_dir/service/$project"
if [[ -e $api_dir || -e $service_dir ]];  then
    echo "${project} 项目已存在"
    exit 0
fi


echo $api_dir
echo $service_dir

mkdir -p $api_dir $service_dir

cp -r $parent_dir/api/demo/demo.proto $api_dir/$project.proto && cp -r $parent_dir/service/demo/ $service_dir/

rm -rf $service_dir/tmp $service_dir/bin

# 项目名首字母大写
up_case_project="$(tr '[:lower:]' '[:upper:]' <<< ${project:0:1})${project:1}"


echo $service_dir

# 替换相关内容
case $os in
    # mac系统
    'Darwin')
    # 替换service和api的内容
    grep -rl 'demo' $service_dir | xargs -I {} sed -i '' "s#demo#${project}#g" {}
    grep -rl 'Demo' $service_dir | xargs -I {} sed -i '' "s#Demo#${up_case_project}#g" {}

    grep -rl 'demo' $api_dir | xargs -I {} sed -i '' "s#demo#${project}#g" {}
    grep -rl 'Demo' $api_dir | xargs -I {} sed -i '' "s#Demo#${up_case_project}#g" {}
    echo 'macos sed'
    ;;
    *)
    # linux系统, win用wsl2或git bash执行, 主要跟mac系统差个 -i ''
    grep -rl 'demo' $service_dir | xargs -I {} sed -i "s#demo#${project}#g" {}
    grep -rl 'Demo' $service_dir | xargs -I {} sed -i "s#Demo#${up_case_project}#g" {}

    grep -rl 'demo' $api_dir | xargs -I {} sed -i "s#demo#${project}#g" {}
    grep -rl 'Demo' $api_dir | xargs -I {} sed -i "s#Demo#${up_case_project}#g" {}

    echo 'linux sed'
    ;;
esac