package model

import (
	"github.com/shopspring/decimal"
)

type CacheUser struct {
	Id    int
	Token string
}

type ImsDbPlayMember struct {
	Id                int             `json:"id"`                 // Id
	UserNo            int             `json:"user_no"`            // 用户编号
	QqOpenid          string          `json:"qq_openid"`          // QQ的openid
	Openid            string          `json:"openid"`             // openid 微信唯一标识
	UnionId           string          `json:"union_id"`           // UnionId
	FaceId            int64           `json:"face_id"`            // facebook的用户id
	GoogleId          string          `json:"google_id"`          // 谷歌登录用户id
	Nickname          string          `json:"nickname"`           // 会员昵称
	Realname          string          `json:"realname"`           // 真实姓名
	Zfb               string          `json:"zfb"`                // 支付宝账号
	Mobile            string          `json:"mobile"`             // 手机号码
	Avatar            string          `json:"avatar"`             // 头像
	AvatarOld         string          `json:"avatar_old"`         // AvatarOld
	Sex               int             `json:"sex"`                // 性别 0.保密 1.男 2.女
	Password          string          `json:"password"`           // 密码
	Credit1           decimal.Decimal `json:"credit1"`            // 金币余额
	Credit2           decimal.Decimal `json:"credit2"`            // 可提现的钻石
	Credit3           decimal.Decimal `json:"credit3"`            // 总收益的钻石
	Credit4           decimal.Decimal `json:"credit4"`            // 代理金币余额,0没有额度限制大于零有额度限制
	LocationP         string          `json:"location_p"`         // 省
	BirthYear         string          `json:"birth_year"`         // 出生年
	MoneyTime         int             `json:"money_time"`         // MoneyTime
	FamilyTime        int             `json:"family_time"`        // 家族收入点击时间
	NewseeTime        int             `json:"newsee_time"`        // NewseeTime
	NewfansTime       int             `json:"newfans_time"`       // NewfansTime
	InviteTime        int             `json:"invite_time"`        // 邀请收入点击时间
	Createtime        int             `json:"createtime"`         // 创建时间
	Sign              string          `json:"sign"`               // 个性签名
	PushId            string          `json:"push_id"`            // 设备号
	Token             string          `json:"token"`              // app登陆验证
	IdCard            string          `json:"id_card"`            // IdCard
	Exp               decimal.Decimal `json:"exp"`                // 经验值
	VipTime           int             `json:"vip_time"`           // 最后消费时间
	ActiveValue       decimal.Decimal `json:"active_value"`       // ActiveValue
	CharmValue        decimal.Decimal `json:"charm_value"`        // 魅力值
	ContributionValue decimal.Decimal `json:"contribution_value"` // 贡献值
	City              string          `json:"city"`               // 所在的城市
	Country           string          `json:"country"`            // 国家
	CountryTime       int             `json:"country_time"`       // CountryTime
	Love              string          `json:"love"`               // 爱好
	Tip               string          `json:"tip"`                // 标签
	RoomNumber        int             `json:"room_number"`        // RoomNumber
	IsHire            int             `json:"is_hire"`            // 0未签约1签约
	FamilyId          int             `json:"family_id"`          // FamilyId
	Spread            int             `json:"spread"`             // 1非推广员2推广员
	LoginTime         int             `json:"login_time"`         // 最新登录时间
	LoginIp           string          `json:"login_ip"`           // 登录ip
	FollowNumber      int             `json:"follow_number"`      // 关注数量
	FansNumber        int             `json:"fans_number"`        // 粉丝数量
	SeeNumber         int             `json:"see_number"`         // 查看数量
	NoReadIncome      decimal.Decimal `json:"no_read_income"`     // 距离上一次未查看的收入
	NewFansNumber     int             `json:"new_fans_number"`    // 新的查看数量
	NewSeeNumber      int             `json:"new_see_number"`     // 新的查看用户数
	Channel           string          `json:"channel"`            // 渠道注册信息
	AdId              string          `json:"ad_id"`              // 广告ID
	IsNumber          int             `json:"is_number"`          // 是否是特殊靓号，1：否，2：是
	CountryType       int             `json:"country_type"`       // 1国内2国外
	Region            string          `json:"region"`             // Region
	Mailbox           string          `json:"mailbox"`            // 邮箱
	TransferNumber    int             `json:"transfer_number"`    // TransferNumber
	TransferDollar    int             `json:"transfer_dollar"`    // 充值美元数
	TransferMoney     int64           `json:"transfer_money"`     // 已充值金币数
	Agent             int             `json:"agent"`              // 1是代理2非代理
	IsAdmin           int             `json:"is_admin"`           // 0否1是
	UpdateTime        int             `json:"update_time"`        // 更新时间
	ClientVersion     string          `json:"client_version"`     // ClientVersion
	PhoneName         string          `json:"phone_name"`         // PhoneName
	PhoneVersion      string          `json:"phone_version"`      // PhoneVersion
	GroupId           int             `json:"group_id"`           // 分组id
	Vip               int             `json:"vip"`                // vip 等级
	Anchor            int             `json:"anchor"`             // 是否为主播
	PkMoney           decimal.Decimal `json:"pk_money"`           // pk所赢的钻石
	PkNumber          int             `json:"pk_number"`          // pk胜利的次数
	ScoreTime         int             `json:"score_time"`         // 评分时间
	GoTime            int             `json:"go_time"`            // 是否被引导去过
	FirstTime         int             `json:"first_time"`         // FirstTime
	Device            string          `json:"device"`             // Device
	AppleId           string          `json:"apple_id"`           // 苹果id
	RegisterType      int             `json:"register_type"`      // 1facebook2google3手机号4微信5qq6苹果7手机号8华为
	TrackerName       string          `json:"tracker_name"`       // TrackerName
	CampaignName      string          `json:"campaign_name"`      // CampaignName
	SnapchatId        string          `json:"snapchat_id"`        // SnapchatId
}

func (i *ImsDbPlayMember) TableName() string {
	return "ims_db_play_member"
}
