package model

import "github.com/shopspring/decimal"

type ImsDbPlayPaylog struct {
	Id              int             `json:"id"`               // Id
	PayMoney        decimal.Decimal `json:"pay_money"`        // 付款金额(金币)
	PayTime         int             `json:"pay_time"`         // PayTime
	UserId          int             `json:"user_id"`          // 支付者id
	Type            int             `json:"type"`             // 支付类型:1:充值金币2：礼物消费3：猜拳消费4：猜拳退货5：兑换增加6：免费赠送7:全服喇叭8:会员收益9:会员消费10:任务奖励11:其他消费12召唤粉丝13召唤会员14房间上锁15置顶16创建房间17创建家族18道具消耗19背景消费20转盘消耗21转盘退款22创建活动消耗23pk消费24活动奖励25房间扶持26背景返还27竞拍定金28竞拍余额支付29定金返还30分组发放金币31pk奖励32召唤成员33H5活动消费34ludo消费35ludo收入36ludo退款37游戏罚金 38特殊关系退款39房间转盘消耗40房间转盘收入41房间红包消耗42房间红包获得43红包退款44 砸金蛋45ludo退款46domino退款47okey退款48drum退款49活动退款50-水果机下注51水果机赢取52房间抽奖消耗53房间抽奖获得54房间抽奖退款55 房间认证获得 56luck_box消耗 57luck_box获得58房间任务奖励 59大富翁消耗60大富翁获胜61充值奖励62banner申请63banner拒绝返回
	FamilyId        int             `json:"family_id"`        // FamilyId
	GoldLog         int             `json:"gold_log"`         // 是否已经导入gold_log表，1导入，0为导入
	Remark          int             `json:"remark"`           // 备注信息
	AuctionId       int             `json:"auction_id"`       // 竞拍ID
	GoldConsumption int             `json:"gold_consumption"` // 是否已经导入gold_log表，1导入，0为导入
}

func (i *ImsDbPlayPaylog) TableName() string {
	return "ims_db_play_paylog"
}
