package client

import (
	"github.com/asim/go-micro/plugins/client/grpc/v4"
	"github.com/asim/go-micro/plugins/registry/consul/v4"
	"go-micro.dev/v4"
	"go-micro.dev/v4/client"
	"go-micro.dev/v4/registry"
	"go-micro.dev/v4/selector"
	"gomicro-base/api/member"
	"gomicro-base/service/wallet/internal/conf"
)

var (
	microService micro.Service
	cf           *conf.Config
)

func NewMicroClient(c *conf.Config) {
	cf = c
	microRegistry := consul.NewRegistry(registry.Addrs(c.Server.ConsulServer...))
	// 轮询访问
	newSelector := selector.NewSelector(
		selector.Registry(microRegistry),
		selector.SetStrategy(selector.RoundRobin),
	)

	microService = micro.NewService(
		micro.Client(grpc.NewClient()),
		micro.Selector(newSelector),
		micro.WrapClient(NewTimeoutWrapper),
		//micro.WrapClient(NewLogWrapper),
	)
}

func GetService() micro.Service {
	return microService
}

func GetClient() client.Client {
	return microService.Client()
}

func Reconnect() {
	NewMicroClient(cf)
}

func GetMemberSvc() member.MemberService {
	return member.NewMemberService(conf.Conf.Client.Member, microService.Client())
}
