package client

import (
	"context"
	"go-micro.dev/v4/client"
	"time"
)

type timeoutWrapper struct {
	client.Client
}

func NewTimeoutWrapper(c client.Client) client.Client {
	return &timeoutWrapper{c}
}

func (t *timeoutWrapper) Call(ctx context.Context, req client.Request, rsp interface{}, opts ...client.CallOption) error {
	timeoutCtx, cancel := context.WithTimeout(ctx, time.Second*2)
	defer cancel()
	return t.Client.Call(timeoutCtx, req, rsp, opts...)
}
