package dao

import (
	"gomicro-base/common/mysql"
	"gomicro-base/common/redis"
	"gomicro-base/service/wallet/internal/conf"
	"gorm.io/gorm"
)

// Dao 查询数据库
type Dao struct {
	DB    *gorm.DB
	Redis *redis.WrapClient
}

func New(c *conf.Config) (d *Dao) {
	d = &Dao{
		DB:    mysql.NewDB(c.Mysql),
		Redis: redis.NewRedis(c.Redis),
	}
	return
}
