package server

import (
	"context"
	"gomicro-base/api/wallet"
	"gomicro-base/service/wallet/internal/service"
)

// 检查接口实现
var _ wallet.WalletHandler = &handler{}

// handler类似控制器
type handler struct {
	svc *service.WalletService
}

func (h *handler) ChargeOne(ctx context.Context, req *wallet.ChargeOneReq, resp *wallet.ChargeOneResp) error {
	return h.svc.ChargeOne(ctx, req)
}

func (h *handler) AddGold(ctx context.Context, req *wallet.AddGoldReq, resp *wallet.AddGoldResp) error {
	return h.svc.AddGold(ctx, req)
}
